<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "../censa/mysql_connection.php";

// Include email functionality file
require_once "../censa/send_email.php";

// Directory containing CSV files
$csv_directory = "../../databank/sap/sales_zsd/";

// Destination folders
$doneFolder = "../../temp_file_csv/sap/zsd_sales/done/";
$errorFolder = "../../temp_file_csv/sap/zsd_sales/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Set the batch size
//$batch_size = 500; // Adjust this value based on your requirements

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    //$line_count = 0;
    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 0,",")) !== false) {

        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }
        // Extract data from the CSV line
        $sales_income_gl = "";
        

        $company_code = isset($line_of_text[0]) ? $line_of_text[0] : null;
        $plant = isset($line_of_text[1]) ? $line_of_text[1] : null;
        //$tl_name = isset($line_of_text[2]) ? $line_of_text[2] : null;
        //$tl_no = isset($line_of_text[3]) ? $line_of_text[3] : null;
        //$sr_name = isset($line_of_text[4]) ? $line_of_text[4] : null;
        //$sr_no = isset($line_of_text[5]) ? $line_of_text[5] : null;
        //$sh_name = isset($line_of_text[6]) ? $line_of_text[6] : null;
        //$sh_no = isset($line_of_text[7]) ? $line_of_text[7] : null;
        //$zh_name = isset($line_of_text[8]) ? $line_of_text[8] : null;
        //$zh_no = isset($line_of_text[9]) ? $line_of_text[9] : null;
        //$mtl_name = isset($line_of_text[10]) ? $line_of_text[10] : null;
        //$mtl_no = isset($line_of_text[11]) ? $line_of_text[11] : null;
        $inv_no = isset($line_of_text[12]) ? $line_of_text[12] : null;
        $clearing_doc_no = isset($line_of_text[13]) ? $line_of_text[13] : 'NULL';
        $diff_bw_days = isset($line_of_text[16]) ? $line_of_text[16] : null;
        $status = isset($line_of_text[17]) ? $line_of_text[17] : null;
        $so_no = isset($line_of_text[21]) ? $line_of_text[21] : null;
        $cogs_amount = isset($line_of_text[26]) ? $line_of_text[26] : null;
        $cogs_glname = isset($line_of_text[27]) ? $line_of_text[27] : null;
        /* $cogs_glcode = isset($line_of_text[13]) ? $line_of_text[13] : 'NULL'; */
        $mat_netweight = isset($line_of_text[29]) ? $line_of_text[29] : null;
        $mat_grossweight = isset($line_of_text[30]) ? $line_of_text[30] : null;
        $bill_qty_in_kg = isset($line_of_text[31]) ? $line_of_text[31] : null;
        $so_qty_in_kg = isset($line_of_text[32]) ? $line_of_text[32] : null;
        $first_weight = isset($line_of_text[33]) ? $line_of_text[33] : null;
        $second_weight = isset($line_of_text[37]) ? $line_of_text[37] : null;
        $net_weight = isset($line_of_text[38]) ? $line_of_text[38] : null;
        $despatch_no = isset($line_of_text[42]) ? $line_of_text[42] : null;
        $e_bill_no = isset($line_of_text[43]) ? $line_of_text[43] : null;
        $irn_no = isset($line_of_text[44]) ? $line_of_text[44] : null;
        $ack_no = isset($line_of_text[45]) ? $line_of_text[45] : null;
        $storage_loc = isset($line_of_text[52]) ? $line_of_text[52] : null;
        $s_org = isset($line_of_text[53]) ? $line_of_text[53] : null;
        $s_group = isset($line_of_text[54]) ? $line_of_text[54] : null;
        $billing_type = isset($line_of_text[55]) ? $line_of_text[55] : null;
        $dist_chnl = isset($line_of_text[56]) ? $line_of_text[56] : null;
        $division = isset($line_of_text[57]) ? $line_of_text[57] : null;
        $gstn_no = isset($line_of_text[58]) ? $line_of_text[58] : null;
        $customer_po_no = isset($line_of_text[59]) ? $line_of_text[59] : null;
        $customer_type = isset($line_of_text[60]) ? $line_of_text[60] : null;
        $customer_no = isset($line_of_text[61]) ? $line_of_text[61] : null;
        $ship_to_party_no = isset($line_of_text[62]) ? $line_of_text[62] : null;
        $digigate_id = isset($line_of_text[63]) ? $line_of_text[63] : null;
        $material_code = isset($line_of_text[64]) ? $line_of_text[64] : null;
        $product_cat_level = isset($line_of_text[65]) ? $line_of_text[65] : null;
        $brand_level = isset($line_of_text[66]) ? $line_of_text[66] : null;
        $product_hie = isset($line_of_text[67]) ? $line_of_text[67] : null;
        $product = isset($line_of_text[68]) ? $line_of_text[68] : null;
        $product = isset($line_of_text[69]) ? $line_of_text[69] : null;
        $product_category = isset($line_of_text[70]) ? $line_of_text[70] : null;
        $brand = isset($line_of_text[71]) ? $line_of_text[71] : null;
        $hsn_code = isset($line_of_text[72]) ? $line_of_text[72] : null;
        $uom = isset($line_of_text[73]) ? $line_of_text[73] : null;
        $so_qty = isset($line_of_text[74]) ? $line_of_text[74] : null;
        $inv_qty = isset($line_of_text[75]) ? $line_of_text[75] : null;
        $rate_inr = isset($line_of_text[76]) ? $line_of_text[76] : null;
        $primary_freight = isset($line_of_text[77]) ? $line_of_text[77] : null;
        $secondary_freight = isset($line_of_text[78]) ? $line_of_text[78] : null;
        $total_freight_charge = isset($line_of_text[79]) ? $line_of_text[79] : null;
        $cgst = number_format(isset($line_of_text[80]) ? $line_of_text[80] : null,2, '.', '');
        $sgst = number_format($line_of_text[81],2, '.', '');
        $igst = number_format($line_of_text[82],2, '.', '');
        $ugst = number_format($line_of_text[83],2, '.', '');
        $tcs = number_format($line_of_text[84],2, '.', '');
        $tot_tax_amt = number_format($line_of_text[85],2, '.', '');
        $gross_value = number_format($line_of_text[86],2, '.', '');
        $total = number_format($line_of_text[87],2, '.', '');
        $basic_value = isset($line_of_text[88]) ? $line_of_text[88] : null;
        $avg_rate_milling = isset($line_of_text[89]) ? $line_of_text[89] : null;
        $cgst_pre = isset($line_of_text[90]) ? $line_of_text[90] : null;
        $sgst_pre = isset($line_of_text[91]) ? $line_of_text[91] : null;
        $igst_pre = isset($line_of_text[92]) ? $line_of_text[92] : null;
        $ugst_pre = isset($line_of_text[93]) ? $line_of_text[93] : null;
        $sal_qty_in_mts = isset($line_of_text[94]) ? $line_of_text[94] : null;
        $bill_qty_in_mts = isset($line_of_text[95]) ? $line_of_text[95] : null;
        $shipment_num = isset($line_of_text[96]) ? $line_of_text[96] : null;
        $tripsheet_num = isset($line_of_text[97]) ? $line_of_text[97] : null;
        $route = isset($line_of_text[98]) ? $line_of_text[98] : null;
        $route_desc = isset($line_of_text[99]) ? $line_of_text[99] : null;
        $driver_name = isset($line_of_text[100]) ? $line_of_text[100] : null;
        $vehicle_num = isset($line_of_text[101]) ? $line_of_text[101] : null;
        $driver_number = isset($line_of_text[102]) ? $line_of_text[102] : null;
        $doc_num = isset($line_of_text[103]) ? $line_of_text[103] : null;
        $payment_days = isset($line_of_text[105]) ? $line_of_text[105] : null;
        $sales_inc_gl_no = isset($line_of_text[106]) ? $line_of_text[106] : null;
        $sales_income_gl_ = isset($line_of_text[107]) ? $line_of_text[107] : null;
        $sgl_amt = isset($line_of_text[108]) ? $line_of_text[108] : null;
        $amt = isset($line_of_text[109]) ? $line_of_text[109] : null;
        $discount = isset($line_of_text[110]) ? str_replace('-', '', $line_of_text[110]) : null;
        $taxable_value = isset($line_of_text[111]) ? $line_of_text[111] : null;
        $employee_discount = isset($line_of_text[112]) ? $line_of_text[112] : null;
        $scrap_tcs = isset($line_of_text[113]) ? $line_of_text[113] : null;
        $delivery_number = isset($line_of_text[114]) ? $line_of_text[114] : null;
        $delivery_quantity = isset($line_of_text[115]) ? $line_of_text[115] : null;
        $pending_qty = isset($line_of_text[116]) ? str_replace('-', '', $line_of_text[116]) : null;
        $pending_qty_in_kg = isset($line_of_text[117]) ? str_replace('-', '', $line_of_text[117]) : null;
        $total_before_tcs = isset($line_of_text[118]) ? $line_of_text[118] : null;
        $tcs_tds = isset($line_of_text[119]) ? $line_of_text[119] : null;
        $shipment_weight = isset($line_of_text[120]) ? $line_of_text[120] : null;
        $SO_reason = isset($line_of_text[121]) ? $line_of_text[121] : null;
        $SO_Line_Item = isset($line_of_text[122]) ? $line_of_text[122] : null;
        

        if($line_of_text[15] == 0){
            $actual_payment_date = NULL;
        }elseif(!empty($line_of_text[15])) {
            $actual_payment_date = date('Y-m-d', strtotime($line_of_text[15]));
        }else{
            $actual_payment_date = NULL;
        }

        if($line_of_text[18] == 0){
            $inv_date = NULL;
        }elseif(!empty($line_of_text[18])) {
            $inv_date = date('Y-m-d', strtotime($line_of_text[18]));
        }else{
            $inv_date = NULL;
        }

        if($line_of_text[14] == 0){
            $due_date = NULL;
        }elseif(!empty($line_of_text[14])) {
            $due_date = date('Y-m-d', strtotime($line_of_text[14]));
        }else{
            $due_date = NULL;
        }

    
        /* if($line_of_text[19] == 0){
            $inv_time = NULL;
        }elseif(!empty($line_of_text[19])) {
            $inv_time = date('H:i:s', strtotime($line_of_text[19]));
        }else{
            $inv_time = NULL;
        } */

        if($line_of_text[20] == 0){
            $inv_date_time = NULL;
        }elseif(!empty($line_of_text[20])) {
            $inv_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[20]));
        }else{
            $inv_date_time = NULL;
        }
        
        /* if($line_of_text[22] == 0){
            $so_date = NULL;
        }elseif(!empty($line_of_text[22])) {
            $so_date = date('Y-m-d', strtotime($line_of_text[22]));
        }else{
            $so_date = NULL;
        }

        if($line_of_text[23] == 0){
            $so_time = NULL;
        }elseif(!empty($line_of_text[23])) {
            $so_time = date('H:i:s', strtotime($line_of_text[23]));
        }else{
            $so_time = NULL;
        } */

        if($line_of_text[24] == 0){
            $so_date_time = NULL;
        }elseif(!empty($line_of_text[24])) {
            $so_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[24]));
        }else{
            $so_date_time = NULL;
        }

        if($line_of_text[25] == 0){
            $shipment_date_time = NULL;
        }elseif(!empty($line_of_text[25])) {
            $shipment_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[25]));
        }else{
            $shipment_date_time = NULL;
        }

        /* if($line_of_text[34] == 0){
            $first_wgt_date = NULL;
        }elseif(!empty($line_of_text[34])) {
            $first_wgt_date = date('Y-m-d', strtotime($line_of_text[34]));
        }else{
            $first_wgt_date = NULL;
        }

        if($line_of_text[35] == 0){
            $first_wgt_time = NULL;
        }elseif(!empty($line_of_text[35])) {
            $first_wgt_time = date('H:i:s', strtotime($line_of_text[35]));
        }else{
            $first_wgt_time = NULL;
        } */
        
        if($line_of_text[36] == 0){
            $first_wgt_date_time = NULL;
        }elseif(!empty($line_of_text[36])) {
            $first_wgt_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[36]));
        }else{
            $first_wgt_date_time = NULL;
        }

        /* if($line_of_text[39] == 0){
            $second_wgt_date = NULL;
        }elseif(!empty($line_of_text[39])) {
            $second_wgt_date = date('Y-m-d', strtotime($line_of_text[39]));
        }else{
            $second_wgt_date = NULL;
        }

        if($line_of_text[40] == 0){
            $second_wgt_time = NULL;
        }elseif(!empty($line_of_text[40])) {
            $second_wgt_time = date('H:i:s', strtotime($line_of_text[40]));
        }else{
            $second_wgt_time = NULL;
        } */

        if($line_of_text[41] == 0){
            $second_wgt_date_time = NULL;
        }elseif(!empty($line_of_text[41])) {
            $second_wgt_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[41]));
        }else{
            $second_wgt_date_time = NULL;
        }

        /* if($line_of_text[46] == 0){
            $despatch_date = NULL;
        }elseif(!empty($line_of_text[46])) {
            $despatch_date = date('Y-m-d', strtotime($line_of_text[46]));
        }else{
            $despatch_date = NULL;
        }
        
        if($line_of_text[47] == 0){
            $despatch_time = NULL;
        }elseif(!empty($line_of_text[47])) {
            $despatch_time = date('H:i:s', strtotime($line_of_text[47]));
        }else{
            $despatch_time = NULL;
        } */

        if($line_of_text[48] == 0){
            $despatch_date_time = NULL;
        }elseif(!empty($line_of_text[48])) {
            $despatch_date_time = date('Y-m-d H:i:s', strtotime($line_of_text[48]));
        }else{
            $despatch_date_time = NULL;
        }

        if($line_of_text[49] == 0){
            $planned_goods_movement_date = NULL;
        }elseif(!empty($line_of_text[49])) {
            $planned_goods_movement_date = date('Y-m-d', strtotime($line_of_text[49]));
        }else{
            $planned_goods_movement_date = NULL;
        }

        if($line_of_text[50] == 0){
            $loading_date = NULL;
        }elseif(!empty($line_of_text[50])) {
            $loading_date = date('Y-m-d', strtotime($line_of_text[50]));
        }else{
            $loading_date = NULL;
        }

        if($line_of_text[51] == 0){
            $delivery_date = NULL;
        }elseif(!empty($line_of_text[51])) {
            $delivery_date = date('Y-m-d', strtotime($line_of_text[51]));
        }else{
            $delivery_date = NULL;
        }

        if($line_of_text[104] == 0){
            $doc_date = NULL;
        }elseif(!empty($line_of_text[104])) {
            $doc_date = date('Y-m-d', strtotime($line_of_text[104]));
        }else{
            $doc_date = NULL;
        }

        $ref_no = $inv_no.$inv_date.$SO_Line_Item;

        if(!empty($line_of_text[13])) {
            $cogs_glcode = $line_of_text[13];
        }else{
            $cogs_glcode = NULL;
        }

        if (substr($cogs_amount, -1) === '-') {
            $cogs_amount = rtrim($cogs_amount, '-');
            $cogs_amount = trim($cogs_amount);
            $cogs_amount = '-' . $cogs_amount;
        }
        if (substr($bill_qty_in_kg, -1) === '-') {
            $bill_qty_in_kg = rtrim($bill_qty_in_kg, '-');
            $bill_qty_in_kg = trim($bill_qty_in_kg);
            $bill_qty_in_kg = '-' . $bill_qty_in_kg;
        }
        if (substr($bill_qty_in_mts, -1) === '-') {
            $bill_qty_in_mts = rtrim($bill_qty_in_mts, '-');
            $bill_qty_in_mts = trim($bill_qty_in_mts);
            $bill_qty_in_mts = '-' . $bill_qty_in_mts;
        }
        if (substr($inv_qty, -1) === '-') {
            $inv_qty = rtrim($inv_qty, '-');
            $inv_qty = trim($inv_qty);
            $inv_qty = '-' . $inv_qty;
        }
        if (substr($cgst, -1) === '-') {
            $cgst = rtrim($cgst, '-');
            $cgst = trim($cgst);
            $cgst = '-' . $cgst;
        }
        if (substr($sgst, -1) === '-') {
            $sgst = rtrim($sgst, '-');
            $sgst = trim($sgst);
            $sgst = '-' . $sgst;
        }
        if (substr($tot_tax_amt, -1) === '-') {
            $tot_tax_amt = rtrim($tot_tax_amt, '-');
            $tot_tax_amt = trim($tot_tax_amt);
            $tot_tax_amt = '-' . $tot_tax_amt;
        }
        if (substr($gross_value, -1) === '-') {
            $gross_value = rtrim($gross_value, '-');
            $gross_value = trim($gross_value);
            $gross_value = '-' . $gross_value;
        }
        if (substr($total, -1) === '-') {
            $total = rtrim($total, '-');
            $total = trim($total);
            $total = '-' . $total;
        }
        if (substr($basic_value, -1) === '-') {
            $basic_value = rtrim($basic_value, '-');
            $basic_value = trim($basic_value);
            $basic_value = '-' . $basic_value;
        }
        if (substr($sgl_amt, -1) === '-') {
            $sgl_amt = rtrim($sgl_amt, '-');
            $sgl_amt = trim($sgl_amt);
            $sgl_amt = '-' . $sgl_amt;
        }
        if (substr($amt, -1) === '-') {
            $amt = rtrim($amt, '-');
            $amt = trim($amt);
            $amt = '-' . $amt;
        }
        if (substr($taxable_value, -1) === '-') {
            $taxable_value = rtrim($taxable_value, '-');
            $taxable_value = trim($taxable_value);
            $taxable_value = '-' . $taxable_value;
        }
        if (substr($pending_qty, -1) === '-') {
            $pending_qty = rtrim($pending_qty, '-');
            $pending_qty = trim($pending_qty);
            $pending_qty = '-' . $pending_qty;
        }
        if (substr($pending_qty_in_kg, -1) === '-') {
            $pending_qty_in_kg = rtrim($pending_qty_in_kg, '-');
            $pending_qty_in_kg = trim($pending_qty_in_kg);
            $pending_qty_in_kg = '-' . $pending_qty_in_kg;
        }
        if (substr($total_before_tcs, -1) === '-') {
            $total_before_tcs = rtrim($total_before_tcs, '-');
            $total_before_tcs = trim($total_before_tcs);
            $total_before_tcs = '-' . $total_before_tcs;
        }
        if (substr($shipment_weight, -1) === '-') {
            $shipment_weight = rtrim($shipment_weight, '-');
            $shipment_weight = trim($shipment_weight);
            $shipment_weight = '-' . $shipment_weight;
        }

        
        // Insert data into the MySQL database
        $sql = "INSERT INTO sap_zsd_sales (ref_no, CompanyCode, Plant, InvNo, ClearingDocNo, DueDate, ActualPaymentDate, DiffBetweenDays, Status, InvDateTime, SONo, SODateTime, ShipmentDateTime, COGSAmount, COGSGLName, COGSGLCode, MATNetWeight, MATGrossWeight, BillQtyInKG, SOQtyInKG, FirstWeight, FirstWgtDateTime, SecondWeight, NetWeight, SecondWgtDateTime, DespatchNo, EBillNo, IRNNo, ACKNo, DespatchDateTime, PlannedGoodsMovementDate, LoadingDate, DeliveryDate, StorageLoc, SOrg, SGroup, BillingType, DistChnl, Division, GSTNNo, CustomerPoNo, CustomerType, CustomerNo, ShipToPartyNo,DigigateID, MaterialCode, ProductCatLevel, BrandLevel, ProductHie, Product, ProductCategory, Brand, HSNCode, UOM, SOQty, InvQty, RateINR, PrimaryFreight, SecondaryFreight, TotalFreightCharge, CGST, SGST, IGST, UGST, TCS, TotTaxAmt, GrossValue, Total, BasicValue, AvgRateMilling, CGSTPercent, SGSTPercent, IGSTPercent, UGSTPercent, SalQtyInMTS, BillQtyInMTS, ShipmentNum, TripsheetNum, Route, RouteDesc, DriverName, VehicleNum, DriverNumber, DocNum, DocDate, PaymentDays, SalesIncGLNo, SalesIncomeGL, SGLAmount, Amount, Discount, TaxableValue, EmployeeDiscount, ScrapTCS, DeliveryNumber, DeliveryQuantity, PendingQty, PendingQtyInKG, TotalBeforeTCS, TCSTDS, ShipmentWeight, So_reason, 	SO_Line_Item) 
        VALUES ('$ref_no' ,'$company_code', '$plant', '$inv_no', '$clearing_doc_no', " . ($due_date ? "'$due_date'" : "NULL") . ", " . ($actual_payment_date ? "'$actual_payment_date'" : "NULL") . " , '$diff_bw_days', '$status', " . ($inv_date_time ? "'$inv_date_time'" : "NULL") . ", '$so_no', " . ($so_date_time ? "'$so_date_time'" : "NULL") . ", " . ($shipment_date_time ? "'$shipment_date_time'" : "NULL") . ", '$cogs_amount', '$cogs_glname', " . ($cogs_glcode ? "'$cogs_glcode'" : "NULL") . ", '$mat_netweight', '$mat_grossweight', '$bill_qty_in_kg', '$so_qty_in_kg', '$first_weight', " . ($first_wgt_date_time ? "'$first_wgt_date_time'" : "NULL") . ", '$second_weight', '$net_weight', " . ($second_wgt_date_time ? "'$second_wgt_date_time'" : "NULL") . ", '$despatch_no', '$e_bill_no', '$irn_no', '$ack_no', " . ($despatch_date_time ? "'$despatch_date_time'" : "NULL") . ", " . ($planned_goods_movement_date ? "'$planned_goods_movement_date'" : "NULL") . ", " . ($loading_date ? "'$loading_date'" : "NULL") . ", " . ($delivery_date ? "'$delivery_date'" : "NULL") . ", '$storage_loc', '$s_org', '$s_group', '$billing_type', '$dist_chnl', '$division', '$gstn_no', '$customer_po_no', '$customer_type', '$customer_no', 
        '$ship_to_party_no','$digigate_id','$material_code', '$product_cat_level', '$brand_level', '$product_hie', '$product', '$product_category', '$brand', '$hsn_code', '$uom', '$so_qty', '$inv_qty', '$rate_inr', '$primary_freight', '$secondary_freight', '$total_freight_charge', '$cgst', '$sgst', '$igst', '$ugst', '$tcs', '$tot_tax_amt', '$gross_value', '$total', '$basic_value', '$avg_rate_milling', '$cgst_pre', '$sgst_pre', '$igst_pre', '$ugst_pre', '$sal_qty_in_mts', '$bill_qty_in_mts', '$shipment_num', '$tripsheet_num', '$route', '$route_desc', '$driver_name', '$vehicle_num', '$driver_number', '$doc_num', " . ($doc_date ? "'$doc_date'" : "NULL") . ", '$payment_days', '$sales_inc_gl_no', '$sales_income_gl', '$sgl_amt', '$amt', '$discount', '$taxable_value', '$employee_discount', '$scrap_tcs', '$delivery_number', '$delivery_quantity', '$pending_qty', '$pending_qty_in_kg', '$total_before_tcs', '$tcs_tds', '$shipment_weight','$SO_reason', '$SO_Line_Item' )";

        
        if ($conn->query($sql) !== TRUE) {
            if ($conn->errno == 1062) { // 1062 is the error code for duplicate entry
                // Skip the current line insert
                continue;
            } else {
                // Other error occurred
                $error_occurred = true;
                $error_message = "Error: " . $sql . "<br>" . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                //sendEmail($error_message);

                break; // Exit loop if error occurs
            }
        } else {
            // Store the ID of the successfully inserted row
            $inserted_ids[] = $conn->insert_id;
        }

        /* if ($line_count >= $batch_size) {
            break;
        } */
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

    // If error occurred, remove all entries inserted from this file
    /* if ($error_occurred) {
        // Construct the list of IDs for deletion
        $id_list = implode(",", $inserted_ids);

        // Delete entries from the table
        $delete_sql = "DELETE FROM sap_zsd_sales WHERE id IN ($id_list)";

        if ($conn->query($delete_sql) !== TRUE) {
            echo "Error deleting entries: " . $conn->error;
        }
    } */
}

// Close the database connection
$conn->close();

?>