<?php

// Include MySQL connection file
require_once "mysql_connection.php";

// Define the date range directly in the code
$from_date = '2024-07-01';
$to_date = '2024-07-31';

// Select the invoices to delete
$select_query = "SELECT invoice_no, sales_order_no FROM sap_sales_invoice WHERE billing_date BETWEEN '$from_date' AND '$to_date'";
echo $select_query;
$result = $conn->query($select_query);

if ($result && $result->num_rows > 0) {
    $invoice_nos = [];
    $sales_order_nos = [];

    while ($row = $result->fetch_assoc()) {
        $invoice_nos[] = "'" . $row['invoice_no'] . "'";
        $sales_order_nos[] = "'" . $row['sales_order_no'] . "'";
    }

    $invoice_list = implode(",", $invoice_nos);
    $sales_order_list = implode(",", $sales_order_nos);

    // Update invoice_flag to 0 in sap_sales_order where sales_order_no matches
    $update_flag_query = "UPDATE sap_sales_order SET invoice_flag = 0 WHERE sales_order_no IN ($sales_order_list)";
    if ($conn->query($update_flag_query) !== TRUE) {
        echo "Error updating invoice_flag in sap_sales_order: " . $conn->error;
    } else {
        echo "invoice_flag updated successfully in sap_sales_order.";
    }

    // Delete from sap_sales_invoice_export
    $delete_export_query = "DELETE FROM sap_sales_invoice_export WHERE invoice_no IN ($invoice_list)";
    if ($conn->query($delete_export_query) !== TRUE) {
        echo "Error deleting from sap_sales_invoice_export: " . $conn->error;
    }

    // Delete from sap_sales_invoice_batch
    $delete_batch_query = "DELETE FROM sap_sales_invoice_batch WHERE invoice_no IN ($invoice_list)";
    if ($conn->query($delete_batch_query) !== TRUE) {
        echo "Error deleting from sap_sales_invoice_batch: " . $conn->error;
    }

    // Delete from sap_sales_invoice_item
    $delete_item_query = "DELETE FROM sap_sales_invoice_item WHERE invoice_no IN ($invoice_list)";
    if ($conn->query($delete_item_query) !== TRUE) {
        echo "Error deleting from sap_sales_invoice_item: " . $conn->error;
    }

    // Delete from sap_sales_invoice
    $delete_main_query = "DELETE FROM sap_sales_invoice WHERE billing_date BETWEEN '$from_date' AND '$to_date'";
    if ($conn->query($delete_main_query) === TRUE) {
        echo "Records deleted successfully.";
    } else {
        echo "Error deleting from sap_sales_invoice: " . $conn->error;
    }
} else {
    echo "No invoices found for the given date range.";
}

// Close MySQL connection
$conn->close();

?>
