<?php
require_once "mysql_connection.php";

// Define the date range
$from_date = '2024-07-01'; // Example start date
$to_date = '2024-07-31';   // Example end date

// Fetch relevant invoice numbers based on the date range
$sql_invoices = "SELECT invoice_no FROM sap_sales_invoice WHERE billing_date BETWEEN '$from_date' AND '$to_date'";
$result_invoices = $conn->query($sql_invoices);

if ($result_invoices->num_rows > 0) {
    $invoice_numbers = [];

    while($row = $result_invoices->fetch_assoc()) {
        $invoice_numbers[] = $row['invoice_no'];
    }

    if (!empty($invoice_numbers)) {
        $invoice_numbers_str = implode("','", $invoice_numbers);

        // Fetch records from sap_sales_invoice_item based on the invoice numbers
        $sql_items = "SELECT id, invoice_no, item_no FROM sap_sales_invoice_item WHERE invoice_no IN ('$invoice_numbers_str')";
        $result_items = $conn->query($sql_items);

        if ($result_items->num_rows > 0) {
            $unique_records = [];
            $duplicate_records = [];

            // Iterate through the records
            while($row = $result_items->fetch_assoc()) {
                $unique_key = $row['invoice_no'] . '-' . $row['item_no'];

                if (!isset($unique_records[$unique_key])) {
                    // If the combination of invoice_no and item_no is unique, keep this record
                    $unique_records[$unique_key] = $row['id'];
                } else {
                    // If the combination is a duplicate, add it to the duplicates array
                    $duplicate_records[] = $row;
                }
            }

            // Display duplicates
            if (!empty($duplicate_records)) {
                echo "Duplicate records found:\n";
                foreach ($duplicate_records as $record) {
                    echo "Invoice No: " . $record['invoice_no'] . ", Item No: " . $record['item_no'] . ", ID: " . $record['id'] . "\n";
                }

                // Collect duplicate IDs for deletion
                $duplicate_ids = array_column($duplicate_records, 'id');
                $duplicate_ids_str = implode(',', $duplicate_ids);
                $delete_sql = "DELETE FROM sap_sales_invoice_item WHERE id IN ($duplicate_ids_str)";

                if ($conn->query($delete_sql) === TRUE) {
                    echo "Duplicates removed successfully.";
                } else {
                    echo "Error deleting duplicates: " . $conn->error;
                }
            } else {
                echo "No duplicates found.";
            }
        } else {
            echo "No matching records found in sap_sales_invoice_item.";
        }
    } else {
        echo "No matching invoices found in sap_sales_invoice.";
    }
} else {
    echo "No invoices found in the given date range.";
}

$conn->close();
?>
