<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";
require_once "api_login.php";

// Step 1: Select invoice numbers based on billing_date condition
$sql = "SELECT invoice_no FROM sap_sales_invoice WHERE billing_date between '2024-07-01' and  '2024-07-31'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $invoice_no = $row['invoice_no'];

        // Step 2: Make cURL request for each invoice number
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/invoice_sto_get_mis',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => json_encode(array(
                "request" => array(
                    "company_code" => "9200",
                    "sales_order_no" => "",
                    "invoice_no" => $invoice_no
                )
            )),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic '.base64_encode("$username_api:$password_api"),
                'Cookie: saplb_*=(J2EE6849720)6849750'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // Step 3: Parse the response and update the database
        $response_data = json_decode($response, true);

        if (isset($response_data['response'])) {
            foreach ($response_data['response'] as $invoice) {
                foreach ($invoice['item'] as $item) {
                    if ($item['item_category'] == 'TANN' || $item['item_category'] == 'RENN') {
                        $item_no = $item['item_no'];
                        $unit_price = $item['unit_price'];
                        $net_price = $item['net_price'];

                        // Update the sap_sales_invoice_item table
                        $update_sql = "UPDATE sap_sales_invoice_item SET unit_price = '$unit_price', net_price = '$net_price' WHERE invoice_no = '$invoice_no' AND item_no = '$item_no'";
                        if ($conn->query($update_sql) === TRUE) {
                            echo "Update successful for Invoice No: $invoice_no, Item No: $item_no\n";
                            echo "Unit Price: $unit_price, Net Price: $net_price\n";
                        } else {
                            echo "Error updating record: " . $conn->error;
                        }
                    }
                }
            }
        }
    }
} else {
    echo "0 results";
}

$conn->close();
?>
