<?php
// Error reporting for debugging purposes
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Increase script execution time and memory limit
set_time_limit(0); // Infinite execution time
ini_set('memory_limit', '512M'); // Increase memory limit if needed

// Include MySQL connection file
require_once "mysql_connection.php";
require_once "api_login.php"; // Include API login file
require_once "customer_master_upload.php";

// Function to handle customer upload logic
function uploadCustomer($customer_no) {
    // Assuming customer_master_upload.php has a function called uploadCustomerData
    uploadCustomerData($customer_no);
}

// Check if the connection is established
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Define date range
$start_date = '2024-07-01';
$end_date = '2024-07-31';

// Query to fetch invoice numbers with processed_flag = 0 within the date range
$invoices_query = "
    SELECT invoice_no
    FROM sap_sales_invoice
    WHERE processed_flag = 0
    AND billing_date BETWEEN '$start_date' AND '$end_date'
";

echo $invoices_query;

$invoices_result = $conn->query($invoices_query);

print_r($invoices_result);

if ($invoices_result === false) {
    die("Error fetching invoice numbers: " . $conn->error);
}

$invoice_numbers = [];
while ($invoice = $invoices_result->fetch_assoc()) {
    $invoice_numbers[] = $invoice['invoice_no'];
}

if (count($invoice_numbers) > 0) {
    $invoice_numbers_str = implode("','", $invoice_numbers);

    // Query to fetch invoice items for the selected invoice numbers
    $invoice_items_query = "
        SELECT *
        FROM sap_sales_invoice_item
        WHERE invoice_no IN ('$invoice_numbers_str')
    ";

    $items_result = $conn->query($invoice_items_query);

    if ($items_result === false) {
        die("Error fetching invoice items: " . $conn->error);
    }

    $all_processed = true;

    while ($item = $items_result->fetch_assoc()) {
        // Check if item_no or material is empty
        if (empty($item['item_no']) || empty($item['material'])) {
            echo "Skipping item with empty item_no or material: " . print_r($item, true) . "\n";
            continue;
        }

        $invoice_query = "
            SELECT *
            FROM sap_sales_invoice
            WHERE invoice_no = '" . $item['invoice_no'] . "'
        ";
        $invoice_result = $conn->query($invoice_query);

        if ($invoice_result === false || $invoice_result->num_rows === 0) {
            echo "No invoice found for invoice_no: " . $item['invoice_no'] . "\n";
            $all_processed = false;
            continue;
        }

        $invoice = $invoice_result->fetch_assoc();

        // Fetch related customer data
        if (!isset($invoice['sold_to_party']) || $invoice['sold_to_party'] === null) {
            echo "Sold to party is undefined or null for invoice_no: " . $item['invoice_no'] . ". Uploading customer data.\n";
            uploadCustomer($invoice['sold_to_party']); // Call the customer upload function

            // Fetch the customer name again after the upload
            $customer_query = "
                SELECT name_1
                FROM sap_customer_master
                WHERE customer_no = '" . $invoice['sold_to_party'] . "'
            ";
            $customer_result = $conn->query($customer_query);

            if ($customer_result === false || $customer_result->num_rows === 0) {
                echo "No customer found for sold_to_party after upload: " . $invoice['sold_to_party'] . "\n";
                $customer = ['name_1' => ''];
                $all_processed = false;
                continue;
            } else {
                $customer = $customer_result->fetch_assoc();
            }
        } else {
            $customer_query = "
                SELECT name_1
                FROM sap_customer_master
                WHERE customer_no = '" . $invoice['sold_to_party'] . "'
            ";
            $customer_result = $conn->query($customer_query);

            if ($customer_result === false || $customer_result->num_rows === 0) {
                echo "No customer found for sold_to_party: " . $invoice['sold_to_party'] . "\n";
                $customer = ['name_1' => ''];
            } else {
                $customer = $customer_result->fetch_assoc();
            }
        }

        // Fetch material data
        $material_query = "
            SELECT material_long_des, brand, category, sub_category
            FROM sap_article_master
            WHERE material_number = '" . $item['material'] . "'
        ";
        $material_result = $conn->query($material_query);

        if ($material_result === false || $material_result->num_rows === 0) {
            echo "No material found for material: " . $item['material'] . "\n";
            $material = ['material_long_des' => '', 'brand' => '', 'category' => '', 'sub_category' => ''];
        } else {
            $material = $material_result->fetch_assoc();
        }

        // Prepare INSERT query for target table (sap_invoice_process)
        $insert_query = "
            INSERT INTO sap_invoice_process (
                invoice_no, sales_order_no, billing_type, billing_date,
                distribution_channel, division, customer_group, 
                sold_to_party, bill_to_party, gst_no, ship_to_party, 
                item_no, material, batch, item_category, qty, uom, 
                item_net_weight, unit_price, mrp_amount, discount_amount, 
                net_price, taxable_value, total_amount, HSN_number, 
                TCS_amount, TCS_rate, trade_discount, mktg_discount, 
                distributor_discount, material_long_des, brand, category, 
                sub_category, customer_name
            ) VALUES (
                '" . $invoice['invoice_no'] . "', 
                '" . $invoice['sales_order_no'] . "', 
                '" . $invoice['billing_type'] . "', 
                '" . $invoice['billing_date'] . "',
                '" . $invoice['distribution_channel'] . "', 
                '" . $invoice['division'] . "', 
                '" . $invoice['customer_group'] . "', 
                '" . $invoice['sold_to_party'] . "', 
                '" . $invoice['bill_to_party'] . "', 
                '" . $invoice['gst_no'] . "', 
                '" . $invoice['ship_to_party'] . "',
                '" . $item['item_no'] . "', 
                '" . $item['material'] . "', 
                '" . $item['batch'] . "', 
                '" . $item['item_category'] . "', 
                " . (isset($item['qty']) ? floatval($item['qty']) : 'NULL') . ", 
                '" . $item['uom'] . "', 
                " . (isset($item['item_net_weight']) ? floatval($item['item_net_weight']) : 'NULL') . ", 
                " . (isset($item['unit_price']) ? floatval($item['unit_price']) : 'NULL') . ",
                " . (isset($item['mrp_amount']) ? floatval($item['mrp_amount']) : 'NULL') . ", 
                " . (isset($item['discount_amount']) ? floatval($item['discount_amount']) : 'NULL') . ", 
                " . (isset($item['net_price']) ? floatval($item['net_price']) : 'NULL') . ", 
                " . (isset($item['taxable_value']) ? floatval($item['taxable_value']) : 'NULL') . ",
                " . (isset($item['total_amount']) ? floatval($item['total_amount']) : 'NULL') . ", 
                '" . $item['HSN_number'] . "', 
                " . (isset($item['TCS_amount']) ? floatval($item['TCS_amount']) : 'NULL') . ", 
                " . (isset($item['TCS_rate']) ? floatval($item['TCS_rate']) : 'NULL') . ", 
                " . (isset($item['trade_discount']) ? floatval($item['trade_discount']) : 'NULL') . ",
                " . (isset($item['mktg_discount']) ? floatval($item['mktg_discount']) : 'NULL') . ", 
                " . (isset($item['distributor_discount']) ? floatval($item['distributor_discount']) : 'NULL') . ", 
                '" . $material['material_long_des'] . "', 
                '" . $material['brand'] . "',
                '" . $material['category'] . "', 
                '" . $material['sub_category'] . "', 
                '" . $conn->real_escape_string($customer['name_1'] ?? '') . "'
            )
        ";

        if ($conn->query($insert_query)) {
            // Update processed_flag
            $update_query = "
                UPDATE sap_sales_invoice
                SET processed_flag = 1
                WHERE invoice_no = '" . $item['invoice_no'] . "'
            ";

            if (!$conn->query($update_query)) {
                echo "Error updating processed_flag for invoice_no: " . $item['invoice_no'] . "\n";
                $all_processed = false;
            }
        } else {
            // Handle duplicate entry error
            if ($conn->errno == 1062) {
                echo "Skipping duplicate entry for invoice_no: " . $item['invoice_no'] . " and item_no: " . $item['item_no'] . "\n";
            } else {
                echo "Error inserting into sap_invoice_process: " . $conn->error . "\n";
                $all_processed = false;
            }
        }
    }

    if ($all_processed) {
        echo "All invoices processed successfully.\n";
    } else {
        echo "Some invoices were not processed successfully.\n";
    }
} else {
    echo "No invoices found within the date range.\n";
}

$conn->close();
?>
