<?php
date_default_timezone_set('Asia/Kolkata');
require_once "mysql_connection.php";
require_once "api_login.php";

$current_date = date('Y-m-d');

$three_hours_ago_start = date('Y-m-d:H:i:s', strtotime('-12 hours'));
$current_date_time = date('Y-m-d:H:i:s');

// Initialize cURL
$curl = curl_init();

// Set cURL options
curl_setopt_array($curl, array(
    CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/sales_order_get',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_POSTFIELDS =>'{
        "request": {
            "from_date": "",
            "to_date": "",
            "sales_org": "9200",
            "delivery_from_date": "",
            "delivery_to_date": "",
            "sales_order_no": "",
            "updated_at": "",
            "plant": "",
            "updated_on_from_date_time": "'.$three_hours_ago_start.'",
            "updated_on_to_date_time": "'.$current_date_time.'",
            "company_code": "9200"
        }
    }',
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'Authorization: Basic '.base64_encode("$username_api:$password_api"),
        'Cookie: saplb_*=(J2EE6849720)6849750'
    ),
));

// Execute the cURL request and capture the response
$json_data = curl_exec($curl);

// Check for cURL errors
if ($json_data === false) {
    echo "cURL Error: " . curl_error($curl) . "<br>";
    exit;
}

// Close the cURL session
curl_close($curl);

// Decode JSON data
$data = json_decode($json_data, true);

// Check for JSON decoding errors
if ($data === null) {
    echo "Error decoding JSON data: " . json_last_error_msg() . "<br>";
    exit;
}

// Insert or update data into database
foreach ($data['response'] as $response) {
    $sales_order_no = $response['sales_order_no'];

    // Check if the sales order number already exists
    $check_sql = "SELECT COUNT(*) as count FROM sap_sales_order WHERE sales_order_no = '$sales_order_no'";
    $check_result = $conn->query($check_sql);

    // Check for SQL query execution errors
    if ($check_result === false) {
        echo "Error checking existing sales order: " . $conn->error . "<br>";
        continue; // Skip this iteration and proceed with the next one
    }

    $row = $check_result->fetch_assoc();
    $count = $row['count'];

    if ($count > 0) {
        // Update existing record in main table
        $sql = "UPDATE sap_sales_order SET
                sales_document_type = '".mysqli_real_escape_string($conn, $response['sales_document_type'])."', 
                sales_organization = '".mysqli_real_escape_string($conn, $response['sales_organization'])."', 
                distribution_channel = '".mysqli_real_escape_string($conn, $response['distribution_channel'])."', 
                distribution_channel_description = '".mysqli_real_escape_string($conn, $response['distribution_channel_description'])."', 
                division = '".mysqli_real_escape_string($conn, $response['division'])."', 
                customer_ref_no = '".mysqli_real_escape_string($conn, $response['customer_ref_no'])."', 
                cust_refer_date = " . ($response['cust_refer_date'] ? "'" . mysqli_real_escape_string($conn, $response['cust_refer_date']) . "'" : "NULL") . ",
                req_del_date = '".mysqli_real_escape_string($conn, $response['req_del_date'])."', 
                order_date = '".mysqli_real_escape_string($conn, $response['order_date'])."', 
                plant = '".mysqli_real_escape_string($conn, $response['plant'])."', 
                net_weight = '".mysqli_real_escape_string($conn, $response['net_weight'])."', 
                sold_to_party = '".mysqli_real_escape_string($conn, $response['sold_to_party'])."', 
                sold_to_party_description = '".mysqli_real_escape_string($conn, $response['sold_to_party_description'])."', 
                ship_to_party = '".mysqli_real_escape_string($conn, $response['ship_to_party'])."', 
                overall_status = '".mysqli_real_escape_string($conn, $response['overall_status'])."', 
                updated_at = '".mysqli_real_escape_string($conn, $response['updated_at'])."', 
                updated_on_time = '".mysqli_real_escape_string($conn, $response['updated_on_time'])."', 
                company_code = '".mysqli_real_escape_string($conn, $response['company_code'])."' ,
                invoice_flag = '0',
                rejection_flag = '0'
                WHERE sales_order_no = '$sales_order_no'";

        // Execute SQL update query
        if ($conn->query($sql) === TRUE) {
            echo "Main record updated successfully for sales order: $sales_order_no<br>";
            //echo $sql;
        } else {
            echo "Error updating main record for sales order: $sales_order_no - " . $conn->error . "<br>";
        }
    } else {
        // Insert new record into main table
        $sql = "INSERT INTO sap_sales_order (sales_order_no, sales_document_type, sales_organization, distribution_channel, distribution_channel_description, division, customer_ref_no, cust_refer_date, req_del_date, order_date, plant, net_weight, sold_to_party, sold_to_party_description, ship_to_party, overall_status, updated_at, updated_on_time, company_code)
                VALUES ('$sales_order_no', '".mysqli_real_escape_string($conn, $response['sales_document_type'])."', '".mysqli_real_escape_string($conn, $response['sales_organization'])."', '".mysqli_real_escape_string($conn, $response['distribution_channel'])."', '".mysqli_real_escape_string($conn, $response['distribution_channel_description'])."', '".mysqli_real_escape_string($conn, $response['division'])."', '".mysqli_real_escape_string($conn, $response['customer_ref_no'])."', " . ($response['cust_refer_date'] ? "'" . mysqli_real_escape_string($conn, $response['cust_refer_date']) . "'" : "NULL") . ", '".mysqli_real_escape_string($conn, $response['req_del_date'])."', '".mysqli_real_escape_string($conn, $response['order_date'])."', '".mysqli_real_escape_string($conn, $response['plant'])."', '".mysqli_real_escape_string($conn, $response['net_weight'])."', '".mysqli_real_escape_string($conn, $response['sold_to_party'])."', '".mysqli_real_escape_string($conn, $response['sold_to_party_description'])."', '".mysqli_real_escape_string($conn, $response['ship_to_party'])."', '".mysqli_real_escape_string($conn, $response['overall_status'])."', '".mysqli_real_escape_string($conn, $response['updated_at'])."', '".mysqli_real_escape_string($conn, $response['updated_on_time'])."', '".mysqli_real_escape_string($conn, $response['company_code'])."')";
        
        // Execute SQL insert query
        if ($conn->query($sql) === TRUE) {
           // echo "Main record inserted successfully for sales order: $sales_order_no<br>";
        } else {
            //echo "Error inserting main record for sales order: $sales_order_no - " . $conn->error . "<br>";
        }
    }

    // Update or insert data into item table
    foreach ($response['item'] as $item) {
        $material_description = $item['material_description'];
        $material_no = $item['material_no'];
        $item_no = $item['item_no'];
    
        // Handle "round_pr" value
        $round_pr = $item['round_pr'];
        if (substr($round_pr, -1) === '-') {
            $round_pr = '-' . rtrim($round_pr, '-');
        }
        // Check if the item already exists
        $check_item_sql = "SELECT COUNT(*) as count FROM sap_sales_order_item WHERE sales_order_no = '$sales_order_no' AND item_no = '$item_no'";
        $check_item_result = $conn->query($check_item_sql);
        if ($check_item_result === false) {
            echo "Error checking existing item: " . $conn->error . "<br>";
            continue; // Skip this iteration and proceed with the next one
        }

        $item_row = $check_item_result->fetch_assoc();
        $item_count = $item_row['count'];

        if ($item_count > 0) {
            // Delete existing record in item table
            $delete_sql = "DELETE FROM sap_sales_order_item WHERE sales_order_no = '$sales_order_no' AND item_no = '$item_no'";
            if ($conn->query($delete_sql) === TRUE) {
                echo "Existing item record deleted successfully for sales order: $sales_order_no<br>";
            } else {
                echo "Error deleting existing item record for sales order: $sales_order_no - " . $conn->error . "<br>";
            }
        }
    
        // Insert new record into item table
        $insert_sql = "INSERT INTO sap_sales_order_item (sales_order_no, material_description, material_no, item_no, order_quantity, plant, storage_location, payment_terms, uom, discount_amount, net_price, taxable_value, cgst_pr, sgst_pr, igst_pr, ugst_pr, total_amount, unit_price, mrp, coss_pr, round_pr,rejection_reason,rejection_reason_text) 
        VALUES ('$sales_order_no', '".mysqli_real_escape_string($conn, $material_description)."', '".mysqli_real_escape_string($conn, $material_no)."', '".mysqli_real_escape_string($conn, $item_no)."', '{$item['order_quantity']}', '".mysqli_real_escape_string($conn, $item['plant'])."', '".mysqli_real_escape_string($conn, $item['storage_location'])."', '".mysqli_real_escape_string($conn, $item['payment_terms'])."', '".mysqli_real_escape_string($conn, $item['uom'])."', '".mysqli_real_escape_string($conn, $item['discount_amount'])."', '".mysqli_real_escape_string($conn, $item['net_price'])."', '".mysqli_real_escape_string($conn, $item['taxable_value'])."', '".mysqli_real_escape_string($conn, $item['cgst_pr'])."', '".mysqli_real_escape_string($conn, $item['sgst_pr'])."', '".mysqli_real_escape_string($conn, $item['igst_pr'])."', '".mysqli_real_escape_string($conn, $item['ugst_pr'])."', '".mysqli_real_escape_string($conn, $item['total_amount'])."', '".mysqli_real_escape_string($conn, $item['unit_price'])."', '".mysqli_real_escape_string($conn, $item['mrp'])."', '".mysqli_real_escape_string($conn, $item['coss_pr'])."', '".mysqli_real_escape_string($conn, $round_pr)."',".(isset($item['rejection_reason']) ? "'".mysqli_real_escape_string($conn, $item['rejection_reason'])."'" : "NULL").", ".(isset($item['rejection_reason_text']) ? "'".mysqli_real_escape_string($conn, $item['rejection_reason_text'])."'" : "NULL").")";
        
        // Execute SQL insert query for item
        if ($conn->query($insert_sql) === TRUE) {
            echo "New item record inserted successfully for sales order: $sales_order_no<br>";

            // Check rejection reason and update flag
            $rejection_reason_check = "SELECT COUNT(*) as count FROM sap_sales_order_item WHERE sales_order_no = '$sales_order_no'";
            $rejection_reason_check_item = "SELECT COUNT(*) as count FROM sap_sales_order_item WHERE sales_order_no = '$sales_order_no' AND rejection_reason IS NOT NULL";
            echo $rejection_reason_check_item;
            echo $rejection_reason_check;
            $reason_row = $conn->query($rejection_reason_check);
            $reason_row_item = $conn->query($rejection_reason_check_item);

            if ($reason_row !== false && $reason_row_item !== false) {
                $check = $reason_row->fetch_assoc()['count'];
                $check_item_re = $reason_row_item->fetch_assoc()['count'];

                echo "Check item " . $check_item_re;
                echo "Check " . $check;

                if ($check > 0 && $check == $check_item_re) {
                    // Update flag
                    $update_sales_order_query = "UPDATE sap_sales_order SET rejection_flag = 1 WHERE sales_order_no = '$sales_order_no'";
                    echo $update_sales_order_query;
                    if ($conn->query($update_sales_order_query) === TRUE) {
                        echo "Flag updated successfully for sales order: $sales_order_no<br>";
                    } else {
                        echo "Error updating flag for sales order: $sales_order_no - " . $conn->error . "<br>";
                    }
                } else {
                    // Update flag to 0
                    $update_sales_order_query = "UPDATE sap_sales_order SET rejection_flag = 0 WHERE sales_order_no = '$sales_order_no'";
                    echo $update_sales_order_query;
                    if ($conn->query($update_sales_order_query) === TRUE) {
                        echo "Flag updated to 0 successfully for sales order: $sales_order_no<br>";
                    } else {
                        echo "Error updating flag to 0 for sales order: $sales_order_no - " . $conn->error . "<br>";
                    }
                }
            } else {
                echo "Error fetching rejection reason for sales order: $sales_order_no - " . $conn->error . "<br>";
            }
        } else {
            echo "Error inserting new item record for sales order: $sales_order_no - " . $conn->error . "<br>";
        }
    }
}

// Close connection
$conn->close();
?>