<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";
require_once "api_login.php";

$sql_sales_order = "SELECT invoice_no FROM sap_sales_invoice_export WHERE flag = 0 LIMIT 10";

$result = $conn->query($sql_sales_order);

// Check if query executed successfully
if ($result) {
    // Loop through each fetched row
    while ($row = $result->fetch_assoc()) {
        // Extract sales_order_no
        $invoice_no_export = $row['invoice_no'];

        // API request payload
        $payload = array(
            "request" => array(
                "company_code" => "9200",
                "invoice_no" => $invoice_no_export
            )
        );
 

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/invoice_sto_get_mis',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Basic '.base64_encode("$username_api:$password_api"),
            'Cookie: saplb_*=(J2EE6849720)6849750'
        ),
    ));

    $json_response = curl_exec($curl);

    curl_close($curl);

    // Decode the JSON response
    $data = json_decode($json_response, true);

    // Check if the response contains "remarks" indicating no data found
    if (isset($data['response'][0]['remarks']) && $data['response'][0]['remarks'] === "No Data Found") {
        echo "No data found for sales order $invoice_no_export";                
    } else {
        foreach ($data['response'] as $response) {
            // Insert into main table
            $net_weight = isset($response['net_weight']) && is_numeric($response['net_weight']) ? ($response['billing_type'] === "RE" ? -1 * $response['net_weight'] : $response['net_weight']) : 0;
            $sql_main = "INSERT INTO sap_sales_invoice (invoice_no, delivery_doc_no, sales_order_no, billing_type, billing_date, document_currency, sales_Org, distribution_channel, division, customer_price_group, customer_group, inco_terms, payment_terms, payment_terms_description, company_code, account_assignment_group, sold_to_party, bill_to_party, payer, plant, net_weight, cancelled_invoice, gst_no, irn, qr, freight_value, ship_to_party)
        VALUES (
            '".$response['invoice_no']."', 
            '".$response['delivery_doc_no']."', 
            '".$response['sales_order_no']."', 
            '".$response['billing_type']."', 
            '".$response['billing_date']."', 
            '".$response['document_currency']."', 
            '".$response['sales_Org']."', 
            '".$response['distribution_channel']."', 
            '".$response['division']."', 
            '".$response['customer_price_group']."', 
            '".$response['customer_group']."', 
            '".$response['inco_terms']."', 
            '".$response['payment_terms']."', 
            '".$response['payment_terms_description']."', 
            '".$response['company_code']."', 
            '".$response['account_assignment_group']."', 
            '".$response['sold_to_party']."', 
            '".$response['bill_to_party']."', 
            '".$response['payer']."', 
            '".$response['plant']."', 
            '".$net_weight."', 
            '".$response['cancelled_invoice']."', 
            '".$response['gst_no']."', 
            '".(isset($response['irn']) ? $response['irn'] : '')."', 
            '".(isset($response['qr']) ? $response['qr'] : '')."',
            '".$response['freight_value']."', 
            '".$response['ship_to_party']."'
        )";
            
            if ($conn->query($sql_main) === TRUE) {
                $last_id = $conn->insert_id;
                echo $sql_main;
                // Insert items
                foreach ($response['item'] as $item) {
                    if ($response['billing_type'] === "ZF5") {
                        // Skip insertion and continue to the next iteration
                        continue;
                    }
                    
                    $freight_amount = !empty(trim($item['freight_amount'])) ? $item['freight_amount'] : 0;
                    $coss_pr = !empty(trim($item['coss_pr'])) ? $item['coss_pr'] : 0;
                    $coss_value = !empty(trim($item['coss_value'])) ? $item['coss_value'] : 0;

                    $qty = floatval(str_replace(',', '', $item['qty']));
                    $item_net_weight = floatval(str_replace(',', '', $item['item_net_weight']));
                    $net_price = floatval(str_replace(',', '', $item['net_price']));
                    $taxable_value = floatval(str_replace(',', '', $item['taxable_value']));
                    $total_amount = floatval(str_replace(',', '', $item['total_amount']));
                    $round_value = $item['round_value'];

                    // Additional check for negative values if needed based on your data
                    if ($response['billing_type'] === "RE" && $qty > 0) {
                        $qty = -1 * $qty;
                    }
                    if ($response['billing_type'] === "RE" && $item_net_weight > 0) {
                        $item_net_weight = -1 * $item_net_weight;
                    }
                    if ($response['billing_type'] === "RE" && $net_price > 0) {
                        $net_price = -1 * $net_price;
                    }
                    if ($response['billing_type'] === "RE" && $taxable_value > 0) {
                        $taxable_value = -1 * $taxable_value;
                    }
                    if ($response['billing_type'] === "RE" && $total_amount > 0) {
                        $total_amount = -1 * $total_amount;
                    }
                    if (substr($round_value, -1) === '-') {

                        //echo " Vanthuten da";
                        // Remove the "-" sign from the end
                        $round_value = rtrim($round_value, '-');
                    
                        // Convert the value to a negative number
                        $round_value = '-' . $round_value;
                    }


                    $sql_item = "INSERT INTO sap_sales_invoice_item (invoice_no, sales_order_no, item_no, material, batch, item_category, plant, qty, uom, item_net_weight, unit_price, mrp_amount, discount_amount, net_price, freight_amount, freight_tax, taxable_value, cgst_pr, cgst_value, sgst_pr, sgst_value, igst_pr, igst_value, ugst_pr, ugst_value, coss_pr, coss_value, total_amount, HSN_number, TCS_amount, TCS_rate, trade_discount, mktg_discount, distributor_discount, round_pr, round_value)
                    VALUES (
                        '".$response['invoice_no']."', 
                        '".$response['sales_order_no']."', 
                        '".$item['item_no']."', 
                        '".$item['material']."', 
                        '".(isset($response['batch']) ? $response['batch'] : '')."', 
                        '".$item['item_category']."', 
                        '".$item['plant']."', 
                        '".$qty."', 
                        '".$item['uom']."', 
                        '".$item_net_weight."', 
                        '".$item['unit_price']."', 
                        '".$item['mrp_amount']."', 
                        '".$item['discount_amount']."', 
                        '".$net_price."', 
                        '".$freight_amount."', 
                        '".$item['freight_tax']."', 
                        '".$taxable_value."', 
                        '".$item['cgst_pr']."', 
                        '".$item['cgst_value']."', 
                        '".$item['sgst_pr']."', 
                        '".$item['sgst_value']."', 
                        '".$item['igst_pr']."', 
                        '".$item['igst_value']."', 
                        '".$item['ugst_pr']."', 
                        '".$item['ugst_value']."', 
                        '".$coss_pr."',  
                        '".$coss_value."', 
                        '".$total_amount."', 
                        '".$item['HSN_number']."', 
                        '".$item['TCS_amount']."', 
                        '".$item['TCS_rate']."', 
                        '".$item['trade_discount']."', 
                        '".$item['mktg_discount']."', 
                        '".$item['distributor_discount']."', 
                        '".$item['round_pr']."', 
                        '".$round_value."'
                    )";
                
                    if ($conn->query($sql_item) === TRUE) {
                        // Get the ID of the last inserted item
                        $item_id = $conn->insert_id;
                    
                        // Output the SQL query for debugging
                        //echo "SQL Query for Item Insertion: " . $sql_item . "<br>";
                    
                        // Insert into batch_line_item table
                        foreach ($item['batch_line_item'] as $batch_item) {
                            $sql_batch_item = "INSERT INTO sap_sales_invoice_batch (invoice_no, sales_order_no, line_item_no, batch, order_qty, sku_code)
                            VALUES (
                                '".$response['invoice_no']."', 
                                '".$response['sales_order_no']."', 
                                '".$batch_item['line_item_no']."', 
                                '".(isset($batch_item['batch']) ? $batch_item['batch'] : '')."', 
                                '".$batch_item['order_qty']."',
                                '".$item['material']."'
                            )";
                    
                            // Output the SQL query for debugging
                            //echo "SQL Query for Batch Item Insertion: " . $sql_batch_item . "<br>";
                    
                            // Execute the SQL query for inserting batch items
                            if ($conn->query($sql_batch_item) !== TRUE) {
                                echo "Error executing batch item insertion query: " . $sql_batch_item . "<br>" . $conn->error;
                            }
                        }
                    } else {
                        echo "Error executing item insertion query: " . $sql_item . "<br>" . $conn->error;
                    }
                    
                }
                
                        
            } else {
                echo "Error: " . $sql_main . "<br>" . $conn->error;
            }
        }
        $update_flag_sql = "UPDATE sap_sales_invoice_export SET flag = 1 WHERE invoice_no = '$invoice_no_export'";
        if ($conn->query($update_flag_sql) === TRUE) {
            echo "Flag status updated successfully for sales order $invoice_no_export";
        } else {
            echo "Error updating flag status: " . $conn->error;
        }
    }
}
} else {
// Handle error if query fails
echo "Error: " . $conn->error;
}

// Close MySQL connection
$conn->close();
?>
