<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";
require_once "api_login.php";

function triggerSalesExportScript() {
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://datawarehouse.diginaga.com/import/sap/sales_export_api.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
    ));

    $response = curl_exec($curl);
    $error = curl_error($curl);

    curl_close($curl);

    if ($error) {
        echo "Error triggering sales export script: " . $error;
        file_put_contents('error_log.txt', "Error triggering sales export script: " . $error . "\n", FILE_APPEND);
    } elseif ($httpCode != 200) {
        echo "Error triggering sales export script: HTTP Code " . $httpCode;
        file_put_contents('error_log.txt', "Error triggering sales export script: HTTP Code " . $httpCode . "\n", FILE_APPEND);
    } else {
        echo "Sales export script triggered successfully.";
        file_put_contents('error_log.txt', "Sales export script triggered successfully.\n", FILE_APPEND);
    }

    return $httpCode == 200;
}

// Query to fetch sales_order_no from sap_sales_order table
$sql_sales_order = "SELECT sales_order_no FROM sap_sales_order WHERE invoice_flag = 0 AND rejection_flag = 0 LIMIT 5000";

$result = $conn->query($sql_sales_order);

// Check if query executed successfully
if ($result) {
    // Loop through each fetched row
    while ($row = $result->fetch_assoc()) {
        // Extract sales_order_no
        $sales_order_no = $row['sales_order_no'];

        // API request payload
        $payload = array(
            "request" => array(
                "company_code" => "9200",
                "sales_order_no" => $sales_order_no
                /* "sales_order_no" => "0006200723" */
            )
        );

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/invoice_sto_get_mis',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic '.base64_encode("$username_api:$password_api"),
                'Cookie: saplb_*=(J2EE6849720)6849750'
            ),
        ));

        $json_response = curl_exec($curl);

        curl_close($curl);

        // Decode the JSON response
        $data = json_decode($json_response, true);

        // Check if the response contains "remarks" indicating no data found
        if (isset($data['response'][0]['remarks']) && $data['response'][0]['remarks'] === "No Data Found") {
            echo "No data found for sales order $sales_order_no";
        } else {
            foreach ($data['response'] as $response) {
                if ($response['billing_type'] === "ZF5") {
                    continue; // Skip checking for billing type ZF5
                }
                $invoice_check = $response['invoice_no'];
                $check_invoice_exist_query = "SELECT * FROM sap_sales_invoice WHERE invoice_no = '$invoice_check'";
                $check_result = $conn->query($check_invoice_exist_query);
                
                if ($check_result->num_rows === 0) {
                    // Start transaction
                    $conn->begin_transaction();

                    // Insert into main table
                    if ($response['distribution_channel'] === "N5") {
                        if ($response['billing_type'] === "BR02") {
                            $invoice_export = $response['invoice_no'];
                            $sales_order_no_export = $response['sales_order_no'];
                    
                            // Check if the invoice already exists
                            $check_invoice_sql = "SELECT COUNT(*) AS count FROM sap_sales_invoice_export WHERE invoice_no = '$invoice_export'";
                            $check_invoice_result = $conn->query($check_invoice_sql);
                            $invoice_row = $check_invoice_result->fetch_assoc();
                            $invoice_count = $invoice_row['count'];
                            if ($invoice_count < 1) {
                                // Insert the invoice data if it doesn't exist
                                $sql_invoice = "INSERT INTO sap_sales_invoice_export (invoice_no, sales_order_no) VALUES ('$invoice_export', '$sales_order_no_export')";
                                if ($conn->query($sql_invoice) === TRUE) {
                                    $update_flag_sql_export = "UPDATE sap_sales_order SET invoice_flag = 1 WHERE sales_order_no = '$sales_order_no_export'";
                                    if ($conn->query($update_flag_sql_export) === TRUE) {
                                        triggerSalesExportScript();
                                    } else {
                                        echo "Error updating flag status for export: " . $conn->error;
                                        $conn->rollback();
                                        continue;
                                    }
                                } else {
                                    echo "Error inserting into sap_sales_invoice_export: " . $conn->error;
                                    $conn->rollback();
                                    continue;
                                }
                            }
                        }
                        continue;
                    }
                    if ($response['billing_type'] === "S2" || $response['billing_type'] === "CAST" ) {
                        $sales_order_no_cencal = $response['sales_order_no'];
                        $sql_main_cencal = "INSERT INTO sap_sales_invoice_cancel (invoice_no, delivery_doc_no, sales_order_no, billing_type, billing_date, document_currency, sales_Org, distribution_channel, division, customer_price_group, customer_group, inco_terms, payment_terms, payment_terms_description, company_code, account_assignment_group, sold_to_party, bill_to_party, payer, plant, net_weight, cancelled_invoice, gst_no, irn, qr, freight_value, ship_to_party)
                        VALUES (
                            '".$response['invoice_no']."', 
                            '".$response['delivery_doc_no']."', 
                            '".$response['sales_order_no']."', 
                            '".$response['billing_type']."', 
                            '".$response['billing_date']."', 
                            '".$response['document_currency']."', 
                            '".$response['sales_Org']."', 
                            '".$response['distribution_channel']."', 
                            '".$response['division']."', 
                            '".$response['customer_price_group']."', 
                            '".$response['customer_group']."', 
                            '".$response['inco_terms']."', 
                            '".$response['payment_terms']."', 
                            '".$response['payment_terms_description']."', 
                            '".$response['company_code']."', 
                            '".$response['account_assignment_group']."', 
                            '".$response['sold_to_party']."', 
                            '".$response['bill_to_party']."', 
                            '".$response['payer']."', 
                            '".$response['plant']."', 
                            '".$response['net_weight']."', 
                            '".$response['cancelled_invoice']."', 
                            '".$response['gst_no']."', 
                            '".(isset($response['irn']) ? $response['irn'] : '')."', 
                            '".(isset($response['qr']) ? $response['qr'] : '')."',
                            '".$response['freight_value']."', 
                            '".$response['ship_to_party']."'
                        )";
                        if ($conn->query($sql_main_cencal) === TRUE) {
                            $update_flag_sql_cencal = "UPDATE sap_sales_order SET invoice_flag = 1 WHERE sales_order_no = '$sales_order_no_cencal'";
                            if ($conn->query($update_flag_sql_cencal) === TRUE) {
                                triggerSalesExportScript();
                            } else {
                                echo "Error updating flag status for cancel: " . $conn->error;
                                $conn->rollback();
                                continue;
                            }
                        } else {
                            echo "Error inserting into sap_sales_invoice_cancel: " . $conn->error;
                            $conn->rollback();
                            continue;
                        }
                    } else {
                        // Check if invoice already exists
                        $check_invoice_sql = "SELECT COUNT(*) AS count FROM sap_sales_invoice WHERE invoice_no = '".$response['invoice_no']."'";
                        $check_invoice_result = $conn->query($check_invoice_sql);
                        $invoice_row = $check_invoice_result->fetch_assoc();
                        $invoice_count = $invoice_row['count'];
                        
                        if ($invoice_count > 0) {
                            echo "Invoice ".$response['invoice_no']." already exists. Skipping process.";
                            continue;
                        }
                        
                        $net_weight = isset($response['net_weight']) && is_numeric($response['net_weight']) ? ($response['billing_type'] === "RE" ? -1 * $response['net_weight'] : $response['net_weight']) : 0;
                        $sql_main = "INSERT INTO sap_sales_invoice (invoice_no, delivery_doc_no, sales_order_no, billing_type, billing_date, document_currency, sales_Org, distribution_channel, division, customer_price_group, customer_group, inco_terms, payment_terms, payment_terms_description, company_code, account_assignment_group, sold_to_party, bill_to_party, payer, plant, net_weight, cancelled_invoice, gst_no, irn, qr, freight_value, ship_to_party)
                        VALUES (
                            '".$response['invoice_no']."', 
                            '".$response['delivery_doc_no']."', 
                            '".$response['sales_order_no']."', 
                            '".$response['billing_type']."', 
                            '".$response['billing_date']."', 
                            '".$response['document_currency']."', 
                            '".$response['sales_Org']."', 
                            '".$response['distribution_channel']."', 
                            '".$response['division']."', 
                            '".$response['customer_price_group']."', 
                            '".$response['customer_group']."', 
                            '".$response['inco_terms']."', 
                            '".$response['payment_terms']."', 
                            '".$response['payment_terms_description']."', 
                            '".$response['company_code']."', 
                            '".$response['account_assignment_group']."', 
                            '".$response['sold_to_party']."', 
                            '".$response['bill_to_party']."', 
                            '".$response['payer']."', 
                            '".$response['plant']."', 
                            '".$net_weight."', 
                            '".$response['cancelled_invoice']."', 
                            '".$response['gst_no']."', 
                            '".(isset($response['irn']) ? $response['irn'] : '')."', 
                            '".(isset($response['qr']) ? $response['qr'] : '')."',
                            '".$response['freight_value']."', 
                            '".$response['ship_to_party']."'
                        )";
                        
                        if ($conn->query($sql_main) === TRUE) {
                            $last_id = $conn->insert_id;

                            // Insert items
                            foreach ($response['item'] as $item) {
                                if ($response['billing_type'] === "ZF5") {
                                    continue;
                                }
                                
                                $freight_amount = !empty(trim($item['freight_amount'])) ? $item['freight_amount'] : 0;
                                $coss_pr = !empty(trim($item['coss_pr'])) ? $item['coss_pr'] : 0;
                                $coss_value = !empty(trim($item['coss_value'])) ? $item['coss_value'] : 0;

                                $qty = floatval(str_replace(',', '', $item['qty']));
                                $item_net_weight = floatval(str_replace(',', '', $item['item_net_weight']));
                                $net_price = floatval(str_replace(',', '', $item['net_price']));
                                $taxable_value = floatval(str_replace(',', '', $item['taxable_value']));
                                $total_amount = floatval(str_replace(',', '', $item['total_amount']));
                                $round_value = $item['round_value'];

                                if ($response['billing_type'] === "RE" && $qty > 0) {
                                    $qty = -1 * $qty;
                                }
                                if ($response['billing_type'] === "RE" && $item_net_weight > 0) {
                                    $item_net_weight = -1 * $item_net_weight;
                                }
                                if ($response['billing_type'] === "RE" && $net_price > 0) {
                                    $net_price = -1 * $net_price;
                                }
                                if ($response['billing_type'] === "RE" && $taxable_value > 0) {
                                    $taxable_value = -1 * $taxable_value;
                                }
                                if ($response['billing_type'] === "RE" && $total_amount > 0) {
                                    $total_amount = -1 * $total_amount;
                                }
                                if (substr($round_value, -1) === '-') {
                                    $round_value = rtrim($round_value, '-');
                                    $round_value = '-' . $round_value;
                                }

                                $sql_item = "INSERT INTO sap_sales_invoice_item (invoice_no, sales_order_no, item_no, material, batch, item_category, plant, qty, uom, item_net_weight, unit_price, mrp_amount, discount_amount, net_price, freight_amount, freight_tax, taxable_value, cgst_pr, cgst_value, sgst_pr, sgst_value, igst_pr, igst_value, ugst_pr, ugst_value, coss_pr, coss_value, total_amount, HSN_number, TCS_amount, TCS_rate, trade_discount, mktg_discount, distributor_discount, round_pr, round_value)
                                VALUES (
                                    '".$response['invoice_no']."', 
                                    '".$response['sales_order_no']."', 
                                    '".$item['item_no']."', 
                                    '".$item['material']."', 
                                    '".(isset($response['batch']) ? $response['batch'] : '')."', 
                                    '".$item['item_category']."', 
                                    '".$item['plant']."', 
                                    '".$qty."', 
                                    '".$item['uom']."', 
                                    '".$item_net_weight."', 
                                    '".$item['unit_price']."', 
                                    '".$item['mrp_amount']."', 
                                    '".$item['discount_amount']."', 
                                    '".$net_price."', 
                                    '".$freight_amount."', 
                                    '".$item['freight_tax']."', 
                                    '".$taxable_value."', 
                                    '".$item['cgst_pr']."', 
                                    '".$item['cgst_value']."', 
                                    '".$item['sgst_pr']."', 
                                    '".$item['sgst_value']."', 
                                    '".$item['igst_pr']."', 
                                    '".$item['igst_value']."', 
                                    '".$item['ugst_pr']."', 
                                    '".$item['ugst_value']."', 
                                    '".$coss_pr."',  
                                    '".$coss_value."', 
                                    '".$total_amount."', 
                                    '".$item['HSN_number']."', 
                                    '".$item['TCS_amount']."', 
                                    '".$item['TCS_rate']."', 
                                    '".$item['trade_discount']."', 
                                    '".$item['mktg_discount']."', 
                                    '".$item['distributor_discount']."', 
                                    '".$item['round_pr']."', 
                                    '".$round_value."'
                                )";
                                
                                if ($conn->query($sql_item) !== TRUE) {
                                    echo "Error inserting into sap_sales_invoice_item: " . $conn->error;
                                    $conn->rollback();
                                    continue 2;  // Continue the outer foreach loop
                                }

                                foreach ($item['batch_line_item'] as $batch_item) {
                                    $sql_batch_item = "INSERT INTO sap_sales_invoice_batch (invoice_no, sales_order_no, line_item_no, batch, order_qty, sku_code)
                                    VALUES (
                                        '".$response['invoice_no']."', 
                                        '".$response['sales_order_no']."', 
                                        '".$batch_item['line_item_no']."', 
                                        '".(isset($batch_item['batch']) ? $batch_item['batch'] : '')."', 
                                        '".$batch_item['order_qty']."',
                                        '".$item['material']."'
                                    )";
                                    if ($conn->query($sql_batch_item) !== TRUE) {
                                        echo "Error inserting into sap_sales_invoice_batch: " . $conn->error;
                                        $conn->rollback();
                                        continue 3;  // Continue the outermost foreach loop
                                    }
                                }
                            }
                            
                            $update_flag_sql = "UPDATE sap_sales_order SET invoice_flag = 1 WHERE sales_order_no = '$sales_order_no'";
                            if ($conn->query($update_flag_sql) !== TRUE) {
                                echo "Error updating flag status: " . $conn->error;
                                $conn->rollback();
                                continue;
                            }
                            
                            $conn->commit();
                            echo "All operations completed successfully for sales order $sales_order_no";
                        } else {
                            echo "Error inserting into sap_sales_invoice: " . $conn->error;
                            $conn->rollback();
                            continue;
                        }
                    }
                }
            }
        }
    }

    // Check if there are cancelled invoices
    $sql_cancelled_invoices = "SELECT cancelled_invoice FROM sap_sales_invoice_cancel WHERE cancel_flag = 0";
    $result_cancelled_invoices = $conn->query($sql_cancelled_invoices);

    if ($result_cancelled_invoices) {
        while ($row_cancelled_invoice = $result_cancelled_invoices->fetch_assoc()) {
            $cancelled_invoice = $row_cancelled_invoice['cancelled_invoice'];

            // Delete cancelled invoice data from related tables
            $sql_delete_invoice = "DELETE FROM `sap_sales_invoice` WHERE invoice_no = '$cancelled_invoice'";
            $sql_delete_invoice_item = "DELETE FROM `sap_sales_invoice_item` WHERE invoice_no = '$cancelled_invoice'";
            $sql_delete_invoice_batch = "DELETE FROM `sap_sales_invoice_batch` WHERE invoice_no = '$cancelled_invoice'";

            if ($conn->query($sql_delete_invoice) === TRUE &&
                $conn->query($sql_delete_invoice_item) === TRUE &&
                $conn->query($sql_delete_invoice_batch) === TRUE) {
                echo "Cancelled invoice data removed successfully for invoice: $cancelled_invoice<br>";
                $cancel_flag_sql = "UPDATE sap_sales_invoice_cancel SET cancel_flag = 1 WHERE cancelled_invoice = '$cancelled_invoice'";
                if ($conn->query($cancel_flag_sql) === TRUE) {
                    echo "Flag status updated successfully for cancel $cancelled_invoice";
                } else {
                    echo "Error updating flag status: " . $conn->error;
                }
            } else {
                echo "Error removing cancelled invoice data: " . $conn->error;
            }
        }
    } else {
        echo "Error retrieving cancelled invoices: " . $conn->error;
    }

} else {
    // Handle error if query fails
    echo "Error: " . $conn->error;
}

// Close MySQL connection
$conn->close();
?>