<?php
// Start session to store OTP and track attempts
session_start();

// MySQL database connection parameters
require_once "../censa/mysql_connection.php";

// Maximum number of allowed attempts
$max_attempts = 3;

// Duration of temporary block (in seconds)
$block_duration = 300; // 5 minutes

// Function to generate OTP
function generateOTP($length = 6) {
    $characters = '0123456789';
    $otp = '';
    for ($i = 0; $i < $length; $i++) {
        $otp .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $otp;
}

// Function to send OTP to registered email address
function sendOTP($email, $otp) {
    // You should implement your email sending logic here
    // For example, using PHPMailer or another library
    // In this example, let's assume it's sent successfully
    $_SESSION['otp'] = $otp;
    return true; // Return true if OTP sent successfully
}

// Function to download CSV
function downloadCSV($data) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="data.csv"');
    $output = fopen("php://output", "w");
    foreach ($data as $row) {
        fputcsv($output, $row);
    }
    fclose($output);
}

// Function to log failed attempts and block IP if exceeded
function logFailedAttempt($ip) {
    if (!isset($_SESSION['attempts'][$ip])) {
        $_SESSION['attempts'][$ip] = 1;
    } else {
        $_SESSION['attempts'][$ip]++;
    }
    if ($_SESSION['attempts'][$ip] >= $GLOBALS['max_attempts']) {
        $_SESSION['blocked'][$ip] = time() + $GLOBALS['block_duration'];
    }
}

// Check if IP is blocked
function isBlocked($ip) {
    return isset($_SESSION['blocked'][$ip]) && $_SESSION['blocked'][$ip] > time();
}

// Check if form submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if IP is blocked
    $ip = $_SERVER['REMOTE_ADDR'];
    if (isBlocked($ip)) {
        echo "You have been temporarily blocked due to multiple failed attempts. Please try again later.";
        exit;
    }

    // Verify OTP
    if (isset($_POST['otp']) && $_POST['otp'] == $_SESSION['otp']) {
        // Fetch data based on selected date range
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $sql = "SELECT * FROM your_table WHERE date_column BETWEEN '$from_date' AND '$to_date'";
        $result = $conn->query($sql);

        // Process data if query successful
        if ($result->num_rows > 0) {
            $data = array();
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            // Download CSV
            downloadCSV($data);
            exit;
        } else {
            echo "No data found for the selected date range.";
        }
    } else {
        logFailedAttempt($ip);
        echo "Invalid OTP. Please try again.";
    }
}

// Generate and send OTP when form submitted with valid email
if (isset($_POST['email'])) {
    $email = $_POST['email'];
    $otp = generateOTP();
    if (sendOTP($email, $otp)) {
        echo "OTP sent to your email. Please enter the OTP to proceed.";
    } else {
        echo "Failed to send OTP. Please try again later.";
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download Data</title>
</head>
<body>
    <h2>Download Data</h2>
    <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <label for="email">Enter your registered email:</label><br>
        <input type="email" id="email" name="email" required><br><br>
        <label for="from_date">From Date:</label><br>
        <input type="date" id="from_date" name="from_date" required><br><br>
        <label for="to_date">To Date:</label><br>
        <input type="date" id="to_date" name="to_date" required><br><br>
        <button type="submit">Request OTP</button>
    </form>

    <?php if (isset($_POST['email'])): ?>
        <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
            <label for="otp">Enter OTP:</label><br>
            <input type="text" id="otp" name="otp" required><br><br>
            <button type="submit">Download CSV</button>
        </form>
    <?php endif; ?>
</body>
</html>

<?php
// Close MySQL connection
$conn->close();
?>
