<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "mysql_connection.php";
require_once "api_login.php";

function uploadCustomerData($customer_no) {
    global $conn, $username_api, $password_api;

    $page_no = 1;
    do {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/customer_master_get',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS =>'{
                "page_no": "'.$page_no.'",
                "request": {
                    "customer_number": "'.$customer_no.'",
                    "distribution_channel": "",
                    "division": "",
                    "company_code": "9200",
                    "sales_org" : "9200"
                }
            }',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic '.base64_encode("$username_api:$password_api"),
            ),
        ));

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            echo 'Error: ' . curl_error($curl);
            curl_close($curl);
            return false; // Return false if there's a curl error
        }

        curl_close($curl);
        $response_data = json_decode($response, true);
        
        if (isset($response_data['response'])) {
            foreach ($response_data['response'] as $entry) {
                $customer_no = $entry['customer_no'];
                $activity_status = $entry['activity_status'];
                $bp_role = $entry['bp_role'];
                $grouping = $entry['grouping'];
                $title = $entry['title'];
                $name_1 = mysqli_real_escape_string($conn, $entry['name_1']);
                $name_2 = mysqli_real_escape_string($conn, $entry['name_2']);
                $name_3 = mysqli_real_escape_string($conn, $entry['name_3']);
                $search_term = mysqli_real_escape_string($conn, $entry['search_term']);
                $building_code = $entry['building_code'];
                $room = $entry['room'];
                $floor = $entry['floor'];
                $c_o = $entry['c_o'];
                $street = mysqli_real_escape_string($conn, $entry['street']);
                $street_2 = mysqli_real_escape_string($conn, $entry['street_2']);
                $street_3 = mysqli_real_escape_string($conn, $entry['street_3']);
                $street_4 = mysqli_real_escape_string($conn, $entry['street_4']);
                $street_5 = mysqli_real_escape_string($conn, $entry['street_5']);
                $district = $entry['district'];
                $city = $entry['city'];
                $postal_code = $entry['postal_code'];
                $country = $entry['country'];
                $region = $entry['region'];
                $language = $entry['language'];
                $telephone_no = $entry['telephone_no'];
                $mobile_no = $entry['mobile_no'];
                $email_no = $entry['email_no'];
                $legacy = $entry['legacy'];
                $tax_category = $entry['tax_category'];
                $tax_no_gst = $entry['tax_no_gst'];
                $check_rule = $entry['check_rule'];
                $latitude = $entry['latitude'];
                $longitude = $entry['longitude'];
                $pan_no = $entry['pan_no'];
                $adhaar_no = $entry['adhaar_no'];
                $passport_no = $entry['passport_no'];
                $kyc_1 = $entry['kyc_1'];
                $kyc_2 = $entry['kyc_2'];
                $route = $entry['route'];
                $salesman = $entry['salesman'];
                $url = $entry['url'];
                $reference_key = $entry['reference_key'];
                $updated_at = $entry['updated_at'];
                $parent_no = $entry['parent_no'];
                $outlet_type = $entry['outlet_type'];

                foreach ($response_data['response'][0]['company'] as $company) {
                    if ($company['company_code'] == 9200) {
                        $reconciliation_account = $company['reconciliation_account'];
                        break;
                    }
                }

                foreach ($response_data['response'][0]['sales_area'] as $sales_area) {
                    if ($sales_area['sales_organization'] == 9200) {
                        $sales_organization = $sales_area['sales_organization'];
                        $distribution_channel = $sales_area['distribution_channel'];
                        $division = $sales_area['division'];
                        $sales_district = $sales_area['sales_district'];
                        $customer_group = $sales_area['customer_group'];
                        $sales_office = $sales_area['sales_office'];
                        $sales_group = $sales_area['sales_group'];
                        $currency = $sales_area['currency'];
                        $price_group = $sales_area['price_group'];
                        $customer_pricing_procedure = $sales_area['customer_pricing_procedure'];
                        $price_list = $sales_area['price_list'];
                        $delivery_priority = $sales_area['delivery_priority'];
                        $order_combination = $sales_area['order_combination'];
                        $delivery_plant = $sales_area['delivery_plant'];
                        $shipping_conditions = $sales_area['shipping_conditions'];
                        $inco_terms = $sales_area['inco_terms'];
                        $inco_terms_location = $sales_area['inco_terms_location'];
                        $payment_terms = $sales_area['payment_terms'];
                        $account_assignment_group = $sales_area['account_assignment_group'];
                        $output_tax_jocg = $sales_area['output_tax_jocg'];
                        $output_tax_josg = $sales_area['output_tax_josg'];
                        $output_tax_joig = $sales_area['output_tax_joig'];
                        $output_tax_joug = $sales_area['output_tax_joug'];
                        $output_tax_jtc1 = $sales_area['output_tax_jtc1'];
                        $output_tax_coss = $sales_area['output_tax_coss'];
                        $status = $sales_area['status'];
                        $credit_control_area = $sales_area['credit_control_area'];
                        $credit_segment = $sales_area['credit_segment'];
                        $credit_limit = $sales_area['credit_limit'];
                        $customer_group_5 = $sales_area['customer_group_5'];
                        $account_at_customer = isset($sales_area['account_at_customer']) ? $sales_area['account_at_customer'] : '';
                        break;
                    }
                }

                $verification_flag = $response_data['response'][0]['verification_flag'];
                $total_page_no = $response_data['pagination']['total_page_no'];
                $current_page_no = $response_data['pagination']['current_page_no'];

                $sql_check = "SELECT COUNT(*) as count FROM sap_customer_master WHERE customer_no = '$customer_no'";
                $result = mysqli_query($conn, $sql_check);
                $row = mysqli_fetch_assoc($result);
                $count = $row['count'];
                if ($count > 0) {
                    $sql_select_updated_at = "SELECT updated_at FROM sap_customer_master WHERE customer_no = '$customer_no'";
                    $result_select_updated_at = mysqli_query($conn, $sql_select_updated_at);
                    $row_select_updated_at = mysqli_fetch_assoc($result_select_updated_at);
                    $existing_updated_at = $row_select_updated_at['updated_at'];
                    if ($existing_updated_at !== $updated_at) {
                        $sql = "UPDATE sap_customer_master SET 
                            activity_status ='$activity_status',bp_role ='$bp_role',grouping ='$grouping',title ='$title',name_1 ='$name_1',name_2 ='$name_2',name_3 ='$name_3',search_term ='$search_term',building_code ='$building_code',room ='$room',floor ='$floor',c_o ='$c_o',street ='$street',street_2 ='$street_2',street_3 ='$street_3',street_4 ='$street_4',street_5 ='$street_5',district ='$district',city ='$city',postal_code ='$postal_code',country ='$country',region ='$region',language ='$language',telephone_no ='$telephone_no',mobile_no ='$mobile_no',email_no ='$email_no',legacy ='$legacy',tax_category ='$tax_category',tax_no_gst ='$tax_no_gst',check_rule ='$check_rule',latitude ='$latitude',longitude ='$longitude',pan_no ='$pan_no',adhaar_no ='$adhaar_no',passport_no ='$passport_no',kyc_1 ='$kyc_1',kyc_2 ='$kyc_2',route ='$route',salesman ='$salesman',url ='$url',reference_key ='$reference_key',updated_at ='$updated_at',parent_no ='$parent_no',outlet_type ='$outlet_type',reconciliation_account ='$reconciliation_account',sales_organization ='$sales_organization',distribution_channel ='$distribution_channel',division ='$division',sales_district ='$sales_district',customer_group ='$customer_group',sales_office ='$sales_office',sales_group ='$sales_group',currency ='$currency',price_group ='$price_group',customer_pricing_procedure ='$customer_pricing_procedure',price_list ='$price_list',delivery_priority ='$delivery_priority',order_combination ='$order_combination',delivery_plant ='$delivery_plant',shipping_conditions ='$shipping_conditions',inco_terms ='$inco_terms',inco_terms_location ='$inco_terms_location',payment_terms ='$payment_terms',account_assignment_group ='$account_assignment_group',output_tax_jocg ='$output_tax_jocg',output_tax_josg ='$output_tax_josg',output_tax_joig ='$output_tax_joig',output_tax_joug ='$output_tax_joug',output_tax_jtc1 ='$output_tax_jtc1',output_tax_coss ='$output_tax_coss',status ='$status',credit_control_area ='$credit_control_area',credit_segment ='$credit_segment',credit_limit ='$credit_limit',customer_group_5 ='$customer_group_5',account_at_customer ='$account_at_customer',verification_flag ='$verification_flag'
                            WHERE customer_no = '$customer_no'";
                    } else {
                        echo "Record already up to date, skipping.\n";
                        continue;
                    }
                } else {
                    $sql = "INSERT INTO sap_customer_master (customer_no, activity_status, bp_role, grouping, title, name_1, name_2, name_3, search_term, building_code, room, floor, c_o, street, street_2, street_3, street_4, street_5, district, city, postal_code, country, region, language, telephone_no, mobile_no, email_no, legacy, tax_category, tax_no_gst, check_rule, latitude, longitude, pan_no, adhaar_no, passport_no, kyc_1, kyc_2, route, salesman, url, reference_key, updated_at, parent_no, outlet_type, reconciliation_account, sales_organization, distribution_channel, division, sales_district, customer_group, sales_office, sales_group, currency, price_group, customer_pricing_procedure, price_list, delivery_priority, order_combination, delivery_plant, shipping_conditions, inco_terms, inco_terms_location, payment_terms, account_assignment_group, output_tax_jocg, output_tax_josg, output_tax_joig, output_tax_joug, output_tax_jtc1, output_tax_coss, status, credit_control_area, credit_segment, credit_limit, customer_group_5, account_at_customer, verification_flag)
                    VALUES ('$customer_no', '$activity_status', '$bp_role', '$grouping', '$title', '$name_1', '$name_2', '$name_3', '$search_term', '$building_code', '$room', '$floor', '$c_o', '$street', '$street_2', '$street_3', '$street_4', '$street_5', '$district', '$city', '$postal_code', '$country', '$region', '$language', '$telephone_no', '$mobile_no', '$email_no', '$legacy', '$tax_category', '$tax_no_gst', '$check_rule', '$latitude', '$longitude', '$pan_no', '$adhaar_no', '$passport_no', '$kyc_1', '$kyc_2', '$route', '$salesman', '$url', '$reference_key', '$updated_at', '$parent_no', '$outlet_type', '$reconciliation_account', '$sales_organization', '$distribution_channel', '$division', '$sales_district', '$customer_group', '$sales_office', '$sales_group', '$currency', '$price_group', '$customer_pricing_procedure', '$price_list', '$delivery_priority', '$order_combination', '$delivery_plant', '$shipping_conditions', '$inco_terms', '$inco_terms_location', '$payment_terms', '$account_assignment_group', '$output_tax_jocg', '$output_tax_josg', '$output_tax_joig', '$output_tax_joug', '$output_tax_jtc1', '$output_tax_coss', '$status', '$credit_control_area', '$credit_segment', '$credit_limit', '$customer_group_5', '$account_at_customer', '$verification_flag')";
                }

                $result = mysqli_query($conn, $sql);

                if ($result === false) {
                    echo "Error executing query: " . mysqli_error($conn);
                } else {
                    $affected_rows = mysqli_affected_rows($conn);
                    if ($affected_rows > 0) {
                        echo "Record inserted/updated successfully.";
                    } else {
                        echo "No records inserted/updated.";
                    }
                }
            }
        }

        $total_page_no = $response_data['pagination']['total_page_no'];
        $current_page_no = $response_data['pagination']['current_page_no'];
        $page_no++;
    } while ($current_page_no < $total_page_no);

    return true;
}
