<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('memory_limit', '4G');
ini_set('error_log', 'logs/error.log');


// Database configuration
$dbHost = 'localhost';
$dbUsername = 'diginaga_data_warehouse';
$dbPassword = 'i!*}xXlc~{J9';
$dbName = 'diginaga_data_warehouse';

// FTP configuration
$ftpHost = 'digi.nagamills.com';
$ftpUsername = 'daemon';
$ftpPassword = 'xampp';
$ftpDir = '/SAP/Backup/data_warehouse';

// Function to create a backup and compress it
function backup_and_compress_table($mysqli, $tableName, $backupDir) {
    // Create the SQL dump
    $backupFile = $backupDir . '/' . $tableName . '.sql';
    $compressedBackupFile = $backupFile . '.gz';

    $createTable = $mysqli->query('SHOW CREATE TABLE ' . $tableName);
    if ($createTable === false) {
        throw new Exception('Error fetching create table statement for ' . $tableName . ': ' . $mysqli->error);
    }
    $createTableRow = $createTable->fetch_array(MYSQLI_NUM);

    $fp = fopen($backupFile, 'w');
    if ($fp === false) {
        throw new Exception('Error opening file for writing: ' . $backupFile);
    }

    fwrite($fp, $createTableRow[1] . ";\n\n");

    $rows = $mysqli->query('SELECT * FROM ' . $tableName);
    if ($rows === false) {
        throw new Exception('Error fetching rows from ' . $tableName . ': ' . $mysqli->error);
    }

    while ($row = $rows->fetch_assoc()) {
        $values = array_map([$mysqli, 'real_escape_string'], array_values($row));
        $values = "'" . implode("','", $values) . "'";
        fwrite($fp, 'INSERT INTO ' . $tableName . ' VALUES(' . $values . ");\n");
    }

    fclose($fp);

    // Compress the backup file
    $fp = fopen($backupFile, 'r');
    $gz = gzopen($compressedBackupFile, 'w9');
    if ($gz === false) {
        throw new Exception('Error opening gzip file for writing: ' . $compressedBackupFile);
    }
    while (!feof($fp)) {
        gzwrite($gz, fread($fp, 1024 * 512));
    }
    fclose($fp);
    gzclose($gz);

    // Remove the uncompressed file
    unlink($backupFile);

    return $compressedBackupFile;
}

// Function to upload a file to the FTP server
function upload_to_ftp($ftpHost, $ftpUsername, $ftpPassword, $ftpDir, $filePath) {
    $connId = ftp_connect($ftpHost);
    if ($connId === false) {
        throw new Exception('Could not connect to FTP server');
    }

    $loginResult = ftp_login($connId, $ftpUsername, $ftpPassword);
    if ($loginResult === false) {
        ftp_close($connId);
        throw new Exception('Could not log in to FTP server');
    }

    ftp_pasv($connId, true); // Enable passive mode
    $uploadResult = ftp_put($connId, $ftpDir . basename($filePath), $filePath, FTP_BINARY);
    if ($uploadResult === false) {
        ftp_close($connId);
        throw new Exception('Error uploading backup file to FTP server');
    }

    ftp_close($connId);
}

try {
    // Create a MySQL database connection
    $mysqli = new mysqli($dbHost, $dbUsername, $dbPassword, $dbName);
    if ($mysqli->connect_error) {
        throw new Exception('Connect Error (' . $mysqli->connect_errno . ') ' . $mysqli->connect_error);
    }

    // Fetch the list of tables
    $tables = $mysqli->query('SHOW TABLES');
    if ($tables === false) {
        throw new Exception('Error fetching table list: ' . $mysqli->error);
    }

    // Directory to store backup files
    $backupDir = 'temp/';
    if (!is_dir($backupDir)) {
        mkdir($backupDir, 0755, true);
    }

    // Loop through each table and back it up
    while ($table = $tables->fetch_array(MYSQLI_NUM)) {
        $tableName = $table[0];
        $compressedBackupFile = backup_and_compress_table($mysqli, $tableName, $backupDir);
        upload_to_ftp($ftpHost, $ftpUsername, $ftpPassword, $ftpDir, $compressedBackupFile);
        unlink($compressedBackupFile); // Remove the local compressed file after uploading
    }

    echo "All tables have been successfully backed up, compressed, and uploaded to the FTP server.";
} catch (Exception $e) {
    error_log($e->getMessage());
    echo "An error occurred: " . $e->getMessage();
}

?>