<?php
date_default_timezone_set('Asia/Kolkata');
require_once "mysql_connection.php";
require_once "api_login.php";

function uploadArticleData($material_number) {
    global $conn, $username_api, $password_api;
    $page_no = 1; // Initial page number

    do {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://103.249.96.90:50000/RESTAdapter/naga_prod/article_master_get',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => json_encode(array(
                "page_no" => $page_no,
                "request" => array(
                    "material_number" => $material_number,
                    "distr_channel" => "",
                    "distribution_centre" => "",
                    "purchasing_org" => "",
                    "company_code" => "9200"
                )
            )),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Basic ' . base64_encode("$username_api:$password_api"),
                'Cookie: saplb_*=(J2EE6849720)6849750'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        echo $response;

        $response_data = json_decode($response, true);

        // Check if 'response' key exists and has data
        if (isset($response_data['response']) && is_array($response_data['response'])) {
            foreach ($response_data['response'] as $entry) {
                // Check if entry already exists and is up-to-date
                $check_query = "SELECT * FROM sap_article_master WHERE material_number = '{$entry['material_number']}' AND updated_at = '{$entry['updated_at']}'";
                $check_result = mysqli_query($conn, $check_query);

                if (mysqli_num_rows($check_result) > 0) {
                    continue;
                }

                // Insert the main article data
                $article_master_insert = "
                INSERT INTO sap_article_master (
                    material_type, material_group, division, material_number, material_desc, 
                    material_long_des, uom, gross_weight, net_weight, minimum_remaining_shelf_life, 
                    total_shelf_life, country_origin_of_material, region_of_orgin, ean_number, ean_category, 
                    trans_group, loading_group, gen_item_cate_group, old_material_number, tax_classification_1, 
                    tax_classification_2, tax_classification_3, tax_classification_4, tax_classification_5, 
                    tax_classification_6, batch_management_required, tax_indicator, updated_at, delition_ind_plant, 
                    deletion_ind_distributiob_chain, brand, category, sub_category, order_UOM, company_code
                ) VALUES (
                    '{$entry['material_type']}', '{$entry['material_group']}', '{$entry['division']}', '{$entry['material_number']}', '{$entry['material_desc']}', 
                    '{$entry['material_long_des']}', '{$entry['uom']}', '{$entry['gross_weight']}', '{$entry['net_weight']}', '{$entry['minimum_remaining_shelf_life']}', 
                    '{$entry['total_shelf_life']}', '{$entry['country_origin_of_material']}', '{$entry['region_of_orgin']}', '{$entry['ean_number']}', '{$entry['ean_category']}', 
                    '{$entry['trans_group']}', '{$entry['loading_group']}', '{$entry['gen_item_cate_group']}', '{$entry['old_material_number']}', '{$entry['tax_classification_1']}', 
                    '{$entry['tax_classification_2']}', '{$entry['tax_classification_3']}', '{$entry['tax_classification_4']}', '{$entry['tax_classification_5']}', 
                    '{$entry['tax_classification_6']}', '{$entry['batch_management_required']}', '{$entry['tax_indicator']}', '{$entry['updated_at']}', '{$entry['delition_ind_plant']}', 
                    '{$entry['deletion_ind_distributiob_chain']}', '{$entry['brand']}', '{$entry['category']}', '{$entry['sub_category']}', '{$entry['order_UOM']}', '{$entry['company_code']}'
                )";

                $result_article_master_insert = mysqli_query($conn, $article_master_insert);
                if ($result_article_master_insert !== TRUE) {
                    echo "Error: " . $article_master_insert . "<br>" . mysqli_error($conn);
                    continue;
                }

                // Insert sales data
                foreach ($entry['sales'] as $sale) {
                    $sales_org_insert = "INSERT INTO sap_article_master_sales_org_insert (
                        material_number, sales_org, distr_channel, sales_unit, account_assignment_group, 
                        item_category_group, gross_weight, net_weight
                    ) VALUES (
                        '{$entry['material_number']}', '{$sale['sales_org']}', '{$sale['distr_channel']}', '{$sale['sales_unit']}', '{$sale['account_assignment_group']}', 
                        '{$sale['item_category_group']}', '{$sale['gross_weight']}', '{$sale['net_weight']}'
                    )";

                    $result_sales_org_insert = mysqli_query($conn, $sales_org_insert);
                    if ($result_sales_org_insert !== TRUE) {
                        echo "Error: " . $sales_org_insert . "<br>" . mysqli_error($conn);
                    }
                }

                // Insert distribution center data
                foreach ($entry['distribution_centre'] as $distribution_center) {
                    $distribution_center_insert = "INSERT INTO sap_article_master_distribution_center (
                        material_number, distribution_center, storage_location, availability_check, mrp_type, 
                        lot_size, mrp_controller, recoder_piont, safety_stock, min_safety_stock, 
                        planned_delivery_time, gr_process_time, mrp_group, minimum_lot_size, maxium_stock_level, 
                        fixed_lot_size, procurement_type, determination_of_batch_entry, production_storage_location, 
                        back_flush, strategy_group, production_scehedule_profile, underdely_tolerance, 
                        overdely_tolerance, rounding_value, forecast_model, period_indicator, no_of_historical_periods, 
                        no_of_forecast_periods, service_level, profit_centre, article_orgin, valuation_category, hsn_code
                    ) VALUES (
                        '{$entry['material_number']}', 
                        IF('{$distribution_center['distribution_center']}' = '', NULL, '{$distribution_center['distribution_center']}'), 
                        '{$distribution_center['storage_location']}', '{$distribution_center['availability_check']}', 
                        '{$distribution_center['mrp_type']}', '{$distribution_center['lot_size']}', 
                        IF('{$distribution_center['mrp_controller']}' = '', NULL, '{$distribution_center['mrp_controller']}'), 
                        IF('{$distribution_center['recoder_piont']}' = '', NULL, '{$distribution_center['recoder_piont']}'), 
                        IF('{$distribution_center['safety_stock']}' = '', NULL, '{$distribution_center['safety_stock']}'), 
                        IF('{$distribution_center['min_safety_stock']}' = '', NULL, '{$distribution_center['min_safety_stock']}'), 
                        IF('{$distribution_center['planned_delivery_time']}' = '', NULL, '{$distribution_center['planned_delivery_time']}'), 
                        IF('{$distribution_center['gr_process_time']}' = '', NULL, '{$distribution_center['gr_process_time']}'), 
                        '{$distribution_center['mrp_group']}', IF('{$distribution_center['minimum_lot_size']}' = '', NULL, '{$distribution_center['minimum_lot_size']}'), 
                        IF('{$distribution_center['maxium_stock_level']}' = '', NULL, '{$distribution_center['maxium_stock_level']}'), 
                        IF('{$distribution_center['fixed_lot_size']}' = '', NULL, '{$distribution_center['fixed_lot_size']}'), 
                        '{$distribution_center['procurement_type']}', '{$distribution_center['determination_of_batch_entry']}', 
                        '{$distribution_center['production_storage_location']}', 
                        IF('{$distribution_center['back_flush']}' = '', NULL, '{$distribution_center['back_flush']}'), 
                        IF('{$distribution_center['strategy_group']}' = '', NULL, '{$distribution_center['strategy_group']}'), 
                        '{$distribution_center['production_scehedule_profile']}', 
                        IF('{$distribution_center['underdely_tolerance']}' = '', NULL, '{$distribution_center['underdely_tolerance']}'), 
                        IF('{$distribution_center['overdely_tolerance']}' = '', NULL, '{$distribution_center['overdely_tolerance']}'), 
                        IF('{$distribution_center['rounding_value']}' = '', NULL, '{$distribution_center['rounding_value']}'), 
                        '{$distribution_center['forecast_model']}', '{$distribution_center['period_indicator']}', 
                        IF('{$distribution_center['no_of_historical_periods']}' = '', NULL, '{$distribution_center['no_of_historical_periods']}'), 
                        '{$distribution_center['no_of_forecast_periods']}', '{$distribution_center['service_level']}', 
                        IF('{$distribution_center['profit_centre']}' = '', NULL, '{$distribution_center['profit_centre']}'), 
                        IF('{$distribution_center['article_orgin']}' = '', NULL, '{$distribution_center['article_orgin']}'), 
                        IF('{$distribution_center['valuation_category']}' = '', NULL, '{$distribution_center['valuation_category']}'), 
                        IF('{$distribution_center['hsn_code']}' = '', NULL, '{$distribution_center['hsn_code']}')
                    )";

                    $result_distribution_center_insert = mysqli_query($conn, $distribution_center_insert);
                    if ($result_distribution_center_insert !== TRUE) {
                        echo "Error: " . $distribution_center_insert . "<br>" . mysqli_error($conn);
                    }
                }
            }
        } else {
            echo "No valid response received or response array empty.";
        }

        $page_no++; // Increment page number for next API call
    } while (isset($response_data['response']) && !empty($response_data['response'])); // Continue loop while there's data in response

    mysqli_close($conn);
}

?>
