<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


require 'vendor/autoload.php'; // Include Composer's autoloader

use MongoDB\Client;

// Load configuration
$config = require 'config.php';

function uploadJsonToMongoDB($config) {
    $jsonFilePath = $config['json_file_path'];
    $mongoServer = $config['mongo_server'];
    $username = $config['username'];
    $password = $config['password'];
    $database = $config['database'];
    $collection = $config['collection'];

    // Connection string
    $uri = "mongodb://$username:$password@$mongoServer";

    // Connect to MongoDB
    $client = new Client($uri);

    // Select database and collection
    $db = $client->$database;
    $coll = $db->$collection;

    // Read the JSON file
    $jsonData = file_get_contents($jsonFilePath);
    $dataArray = json_decode($jsonData, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        die("Invalid JSON data");
    }

    // Insert the data into the collection
    try {
        $insertManyResult = $coll->insertMany($dataArray);
        printf("Inserted %d documents into collection \"%s\".\n", $insertManyResult->getInsertedCount(), $collection);
    } catch (Exception $e) {
        die("Error inserting data: " . $e->getMessage());
    }
}

// Call the function to upload JSON to MongoDB
uploadJsonToMongoDB($config);
?>