<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/vehicle_rate_master/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/vehicle_rate_master/done/";
$errorFolder = "../../temp_file_csv/censa/vehicle_rate_master/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;
    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Extract data from the CSV line
        // Prepare data for insertion
        $unique_id = $line_of_text[0];
        $brand = $line_of_text[1];
        $vehicle_model = $line_of_text[2];
        $transporter_id = !empty($line_of_text[3]) ? "'" . $line_of_text[3] . "'" : 'NULL'; // Handle empty values
        $transporter = !empty($line_of_text[4]) ? "'" . $line_of_text[4] . "'" : 'NULL'; // Handle empty values
        $vendor_code = !empty($line_of_text[5]) ? "'" . $line_of_text[5] . "'" : 'NULL'; // Handle empty values
        $vehicle_type = $line_of_text[6];
        $rate_category_name = !empty($line_of_text[7]) ? "'" . $line_of_text[7] . "'" : 'NULL'; // Handle empty values
        $type = !empty($line_of_text[8]) ? "'" . $line_of_text[8] . "'" : 'NULL'; // Handle empty values
        $plant = !empty($line_of_text[9]) ? "'" . $line_of_text[9] . "'" : 'NULL'; // Handle empty values
        $tonnage = !empty($line_of_text[10]) ? $line_of_text[10] : 'NULL'; // Handle empty values
        $fixed_rental_amount = !empty($line_of_text[11]) ? $line_of_text[11] : 'NULL'; // Handle empty values
        $included_distance = !empty($line_of_text[12]) ? $line_of_text[12] : 'NULL'; // Handle empty values
        $additional_amount = !empty($line_of_text[13]) ? $line_of_text[13] : 'NULL'; // Handle empty values
        $included_hours = !empty($line_of_text[14]) ? $line_of_text[14] : 'NULL'; // Handle empty values
        $additional_amount_per_hour = !empty($line_of_text[15]) ? $line_of_text[15] : 'NULL'; // Handle empty values
        $start_date = !empty($line_of_text[16]) ? "'" . date('Y-m-d', strtotime($line_of_text[16])) . "'" : 'NULL'; // Handle empty values
        $end_date = !empty($line_of_text[17]) ? "'" . date('Y-m-d', strtotime($line_of_text[17])) . "'" : 'NULL'; // Handle empty values
        $contact_person = !empty($line_of_text[18]) ? "'" . $line_of_text[18] . "'" : 'NULL'; // Handle empty values
        $contact = !empty($line_of_text[19]) ? "'" . $line_of_text[19] . "'" : 'NULL'; // Handle empty values
        $email_id = !empty($line_of_text[20]) ? "'" . $line_of_text[20] . "'" : 'NULL'; // Handle empty values
        $registration_no = !empty($line_of_text[21]) ? "'" . $line_of_text[21] . "'" : 'NULL'; // Handle empty values
        $driver_name = !empty($line_of_text[22]) ? "'" . $line_of_text[22] . "'" : 'NULL'; // Handle empty values
        $breadth = !empty($line_of_text[23]) ? $line_of_text[23] : 'NULL'; // Handle empty values
        $height = !empty($line_of_text[24]) ? $line_of_text[24] : 'NULL'; // Handle empty values
        $length = !empty($line_of_text[25]) ? $line_of_text[25] : 'NULL'; // Handle empty values

        // Check if the unique_id already exists in the database
        $check_query = "SELECT COUNT(*) AS count FROM censa_vehicle_rate_master WHERE unique_id = '$unique_id'";
        $result = $conn->query($check_query);

        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);

            if ($existing_count > 0) {
                // If unique_id already exists, update the existing record
                $update_query = "UPDATE censa_vehicle_rate_master SET 
                                    brand = '$brand', 
                                    vehicle_model = '$vehicle_model', 
                                    transporter_id = $transporter_id, 
                                    transporter = $transporter, 
                                    vendor_code = $vendor_code, 
                                    vehicle_type = '$vehicle_type', 
                                    rate_category_name = $rate_category_name, 
                                    type = $type, 
                                    plant = $plant, 
                                    tonnage = $tonnage, 
                                    fixed_rental_amount = $fixed_rental_amount, 
                                    included_distance = $included_distance, 
                                    additional_amount = $additional_amount, 
                                    included_hours = $included_hours, 
                                    additional_amount_per_hour = $additional_amount_per_hour, 
                                    start_date = $start_date, 
                                    end_date = $end_date, 
                                    contact_person = $contact_person, 
                                    contact = $contact, 
                                    email_id = $email_id, 
                                    registration_no = $registration_no, 
                                    driver_name = $driver_name, 
                                    breadth = $breadth, 
                                    height = $height, 
                                    length = $length 
                                WHERE unique_id = '$unique_id'";

                // Execute the update query
                if ($conn->query($update_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error updating record with unique_id = $unique_id: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);

                    break; // Exit loop if error occurs
                } else {
                    echo "Record with unique_id = $unique_id updated successfully.\n";
                }
            } else {
                // If unique_id does not exist, insert a new record
                $insert_query = "INSERT INTO censa_vehicle_rate_master (unique_id, brand, vehicle_model, transporter_id, transporter, vendor_code, vehicle_type, rate_category_name, type, plant, tonnage, fixed_rental_amount, included_distance, additional_amount, included_hours, additional_amount_per_hour, start_date, end_date, contact_person, contact, email_id, registration_no, driver_name, breadth, height, length) 
                                VALUES ('$unique_id', '$brand', '$vehicle_model', $transporter_id, $transporter, $vendor_code, '$vehicle_type', $rate_category_name, $type, $plant, $tonnage, $fixed_rental_amount, $included_distance, $additional_amount, $included_hours, $additional_amount_per_hour, $start_date, $end_date, $contact_person, $contact, $email_id, $registration_no, $driver_name, $breadth, $height, $length)";

                // Execute the insert query
                if ($conn->query($insert_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error inserting record with unique_id = $unique_id: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);
                    break; // Exit loop if error occurs
                }
            }
        } else {
            $error_occurred = true;
            $error_message = "Error querying database: " . $conn->error;
            echo $error_message; // Display error message

            // Send error details via email
            sendEmail($error_message);
            break; // Exit loop if error occurs
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }
}

// Close the database connection
$conn->close();

?>
