<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/trip_planned_primary_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/trip_planned_primary_report/done/";
$errorFolder = "../../temp_file_csv/censa/trip_planned_primary_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }   
        
        
        // Extract data from the CSV line
        $unique_id = $line_of_text[0];
        $trip_date = date('Y-m-d', strtotime($line_of_text[1]));
        $trip_id = $line_of_text[2];
        $plant = $line_of_text[3];
        $secondary_plant_id = $line_of_text[4];
        $secondary_plant_name = $line_of_text[5];
        $transporter_name = $line_of_text[6];
        $transporter_id = $line_of_text[7];
        $transporter_contact_no = $line_of_text[8];
        $vehicle_number = $line_of_text[9];
        $delivery_executive_name_with_phoneno = $line_of_text[10];
        $customer_type = $line_of_text[11];
        $delivery_sequence_no = $line_of_text[12];
        $customer_id = $line_of_text[13];
        $customer_name = $conn->real_escape_string($line_of_text[14]);
        $so_no = $line_of_text[15];
        $inv_no = $line_of_text[16];
        $picking_reference_no = $line_of_text[17];
        $sequence_no = $line_of_text[18];
        $no_of_items_planned = $line_of_text[19];
        $nt_wt_of_so_in_kg = $line_of_text[20];
        $planned_volume_cubic_centimeter = $line_of_text[21];
        $activity_type = $line_of_text[22];
        $report_updated_at = date('Y-m-d H:m:s', strtotime($line_of_text[23]));

        
        // Check if the unique_id already exists in the database
        $check_query = "SELECT COUNT(*) AS count FROM censa_trip_planned_primary_report WHERE unique_id = '$unique_id'";
        $result = $conn->query($check_query);
        
        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);
            if ($existing_count > 0) {
                // If the unique_id exists, update the corresponding row
                echo "Update entry";
                $update_query = "UPDATE censa_trip_planned_primary_report SET
                                trip_date = '$trip_date',
                                trip_id = '$trip_id',
                                plant = '$plant',
                                secondary_plant_id = '$secondary_plant_id',
                                secondary_plant_name = '$secondary_plant_name',
                                transporter_name = '$transporter_name',
                                transporter_id = '$transporter_id',
                                transporter_contact_no = '$transporter_contact_no',
                                vehicle_number = '$vehicle_number',
                                delivery_executive_name_with_phoneno = '$delivery_executive_name_with_phoneno',
                                customer_type = '$customer_type',
                                delivery_sequence_no = '$delivery_sequence_no',
                                customer_id = '$customer_id',
                                customer_name = '$customer_name',
                                so_no = '$so_no',
                                inv_no = '$inv_no',
                                picking_reference_no = '$picking_reference_no',
                                sequence_no = '$sequence_no',
                                no_of_items_planned = '$no_of_items_planned',
                                nt_wt_of_so_in_kg = '$nt_wt_of_so_in_kg',
                                planned_volume_cubic_centimeter = '$planned_volume_cubic_centimeter',
                                activity_type = '$activity_type',
                                report_updated_at = '$report_updated_at'
                            WHERE unique_id = '$unique_id'";

                if ($conn->query($update_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error updating record: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);

                    break; // Exit loop if error occurs
                }
            } else {
                // If the unique_id doesn't exist, insert a new row
                //echo "Insert entry";
                $insert_query = "INSERT INTO censa_trip_planned_primary_report 
                                    (unique_id, trip_date, trip_id, plant, secondary_plant_id, secondary_plant_name, transporter_name, transporter_id, transporter_contact_no, vehicle_number, delivery_executive_name_with_phoneno, customer_type, delivery_sequence_no, customer_id, customer_name, so_no, inv_no, picking_reference_no, sequence_no, no_of_items_planned, nt_wt_of_so_in_kg, planned_volume_cubic_centimeter, activity_type, report_updated_at) 
                                VALUES 
                                    ('$unique_id', '$trip_date', '$trip_id', '$plant', '$secondary_plant_id', '$secondary_plant_name', '$transporter_name', '$transporter_id', '$transporter_contact_no', '$vehicle_number', '$delivery_executive_name_with_phoneno', '$customer_type', '$delivery_sequence_no', '$customer_id', '$customer_name', '$so_no', '$inv_no', '$picking_reference_no', '$sequence_no', '$no_of_items_planned', '$nt_wt_of_so_in_kg', '$planned_volume_cubic_centimeter', '$activity_type', '$report_updated_at')";
                echo $insert_query;
                if ($conn->query($insert_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error inserting record: " . $conn->error;
                    //echo $error_message; // Display error message
    
                    // Send error details via email
                    sendEmail($error_message);
    
                    break; // Exit loop if error occurs
                } else {
                    // Store the ID of the successfully inserted row
                    $inserted_ids[] = $conn->insert_id;
                }
            }
        } else {
            $error_occurred = true;
            $error_message = "Error executing query: " . $conn->error;
            echo $error_message; // Display error message

            // Send error details via email
            sendEmail($error_message);

            break; // Exit loop if error occurs
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }
}

// Close the database connection
$conn->close();

?>
