<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/trip_actual_primary_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/trip_actual_primary_report/done/";
$errorFolder = "../../temp_file_csv/censa/trip_actual_primary_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Extract data from CSV
        $unique_id = $line_of_text[0];
        $trip_date = date('Y-m-d', strtotime($line_of_text[1]));
        $tripid = $line_of_text[2];
        $plant = !empty($line_of_text[3]) ? $line_of_text[3] : 'NULL';
        $secondary_plant_id = $line_of_text[4];
        $secondary_plant_name = $line_of_text[5];
        $transporter_name = $line_of_text[6];
        $transporter_id = !empty($line_of_text[7]) ? $line_of_text[7] : 'NULL';
        $transporter_contact_no = $line_of_text[8];
        $vehicle_number = $line_of_text[9];
        $deliveryexecutive_name_with_phoneno = $line_of_text[10];
        $customer_type = $line_of_text[11];
        $delivery_sequence_no = $line_of_text[12];
        $customer_id = !empty($line_of_text[13]) ? $line_of_text[13] : 'NULL';
        $customer_name = $conn->real_escape_string($line_of_text[14]);
        $so_no = !empty($line_of_text[15]) ? $line_of_text[15] : 'NULL';
        $inv_no = !empty($line_of_text[16]) ? $line_of_text[16] : 'NULL';
        $picking_ref_no = !empty($line_of_text[17]) ? $line_of_text[17] : 'NULL';
        $sequence_no = $line_of_text[18]; // Correct index
        $no_of_items_delivered = !empty($line_of_text[19]) ? $line_of_text[19] : 'NULL';
        $nt_wt_of_so_kg = $line_of_text[20];
        $actual_trip_distance = $line_of_text[21];
        $actual_trip_duration = date('H:i:s', strtotime($line_of_text[22])); // Correct index and format
        $activity_type = $line_of_text[23];
        $visited_status = $line_of_text[24];
        $delivery_status = $line_of_text[25];
        $return_reason = $line_of_text[26];
        $visit_start_time = $line_of_text[27];
        $visit_end_time = $line_of_text[28];
        $service_time = $line_of_text[29];
        $timeslot_range = $line_of_text[30];
        $delivery_time_window_adherence = $line_of_text[31];
        $weight_utilization = !empty($line_of_text[32]) ? $line_of_text[32] : 'NULL';
        $activity_lat_long = $line_of_text[33];
        $actual_lat_long = $line_of_text[34];
        $location_deviation_km = !empty($line_of_text[35]) ? $line_of_text[35] : 'NULL';
        $force_checkin_reason = $line_of_text[36];
        $last_leg = $line_of_text[37];
        $pod_uploaded = $line_of_text[38];
        $pod_location = $line_of_text[39];
        $report_updated_at = $line_of_text[40];

        // Check if the unique_id already exists in the database
        $check_query = "SELECT COUNT(*) AS count FROM censa_trip_actual_primary_report WHERE unique_id = '$unique_id'";
        $result = $conn->query($check_query);

        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);

            if ($existing_count > 0) {
                // If unique_id already exists, update the existing record
                $update_query = "UPDATE censa_trip_actual_primary_report SET 
                    trip_date = '$trip_date', 
                    tripid = '$tripid', 
                    plant = $plant, 
                    secondary_plant_id = '$secondary_plant_id', 
                    secondary_plant_name = '$secondary_plant_name', 
                    transporter_name = '$transporter_name', 
                    transporter_id = $transporter_id, 
                    transporter_contact_no = '$transporter_contact_no', 
                    vehicle_number = '$vehicle_number', 
                    deliveryexecutive_name_with_phoneno = '$deliveryexecutive_name_with_phoneno', 
                    customer_type = '$customer_type', 
                    delivery_sequence_no = '$delivery_sequence_no', 
                    customer_id = $customer_id, 
                    customer_name = '$customer_name', 
                    so_no = $so_no, 
                    inv_no = $inv_no, 
                    sequence_no = '$sequence_no', 
                    no_of_items_delivered = $no_of_items_delivered, 
                    nt_wt_of_so_kg = '$nt_wt_of_so_kg', 
                    actual_trip_distance = '$actual_trip_distance', 
                    actual_trip_duration = '$actual_trip_duration', 
                    activity_type = '$activity_type', 
                    visited_status = '$visited_status', 
                    delivery_status = '$delivery_status', 
                    return_reason = '$return_reason', 
                    visit_start_time = '$visit_start_time', 
                    visit_end_time = '$visit_end_time', 
                    service_time = '$service_time', 
                    timeslot_range = '$timeslot_range', 
                    delivery_time_window_adherence = '$delivery_time_window_adherence', 
                    weight_utilization = $weight_utilization, 
                    activity_lat_long = '$activity_lat_long', 
                    actual_lat_long = '$actual_lat_long', 
                    location_deviation_km = $location_deviation_km, 
                    force_checkin_reason = '$force_checkin_reason', 
                    last_leg = '$last_leg', 
                    pod_uploaded = '$pod_uploaded', 
                    pod_location = '$pod_location', 
                    report_updated_at = '$report_updated_at',
                    picking_ref_no = '$picking_ref_no'
                WHERE unique_id = '$unique_id'";


                // Execute the update query
                if ($conn->query($update_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error updating record with unique_id '$unique_id': " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    // sendEmail($error_message);

                    break; // Exit loop if error occurs
                } else {
                    echo "Record with unique_id '$unique_id' updated successfully<br>";
                }
            } else {
                // If unique_id does not exist, insert a new record
                $insert_query = "INSERT INTO censa_trip_actual_primary_report (unique_id, trip_date, tripid, plant, secondary_plant_id, secondary_plant_name, transporter_name, transporter_id, transporter_contact_no, vehicle_number, deliveryexecutive_name_with_phoneno, customer_type, delivery_sequence_no, customer_id, customer_name, so_no, inv_no, sequence_no, no_of_items_delivered, nt_wt_of_so_kg, actual_trip_distance, actual_trip_duration, activity_type, visited_status, delivery_status, return_reason, visit_start_time, visit_end_time, service_time, timeslot_range, delivery_time_window_adherence, weight_utilization, activity_lat_long, actual_lat_long, location_deviation_km, force_checkin_reason, last_leg, pod_uploaded, pod_location, report_updated_at, picking_ref_no) 
                VALUES ('$unique_id', '$trip_date', '$tripid', $plant, '$secondary_plant_id', '$secondary_plant_name', '$transporter_name', $transporter_id, '$transporter_contact_no', '$vehicle_number', '$deliveryexecutive_name_with_phoneno', '$customer_type', '$delivery_sequence_no', $customer_id, '$customer_name', $so_no, $inv_no, '$sequence_no', $no_of_items_delivered, '$nt_wt_of_so_kg', '$actual_trip_distance', '$actual_trip_duration', '$activity_type', '$visited_status', '$delivery_status', '$return_reason', '$visit_start_time', '$visit_end_time', '$service_time', '$timeslot_range', '$delivery_time_window_adherence', $weight_utilization, '$activity_lat_long', '$actual_lat_long', $location_deviation_km, '$force_checkin_reason', '$last_leg', '$pod_uploaded', '$pod_location', '$report_updated_at', '$picking_ref_no')";
                
                // Execute the insert query
                if ($conn->query($insert_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error inserting record with unique_id '$unique_id': " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    // sendEmail($error_message);

                    break; // Exit loop if error occurs
                } else {
                    echo "Record with unique_id '$unique_id' inserted successfully<br>";
                }
            }
        } else {
            $error_occurred = true;
            $error_message = "Error checking for existing record with unique_id '$unique_id': " . $conn->error;
            echo $error_message; // Display error message

            // Send error details via email
            // sendEmail($error_message);

            break; // Exit loop if error occurs
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

}

// Close the database connection
$conn->close();

?>
