<?php

// Function to split CSV files
function splitCSV($inputFile, $outputFolder, $rowsPerFile = 250) {
    $fileCount = 1;
    $rowCount = 0;
    $outputFile = fopen("$outputFolder/output$fileCount.csv", 'w');

    $handle = fopen($inputFile, "r");

    if ($handle !== FALSE) {
        // Read and store header row
        $headerRow = fgetcsv($handle);

        // Write header row to the first split file
        fputcsv($outputFile, $headerRow);

        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            fputcsv($outputFile, $data);

            $rowCount++;

            if ($rowCount == $rowsPerFile) {
                fclose($outputFile);
                $fileCount++;
                $rowCount = 0;
                $outputFile = fopen("$outputFolder/output$fileCount.csv", 'w');
                
                // Write header row to the new split file
                fputcsv($outputFile, $headerRow);
            }
        }
        fclose($outputFile);
        fclose($handle);
    } else {
        echo "Error: Unable to open file $inputFile.";
    }
}

// Usage
$inputFile = "csvfile/activity.csv"; // Change this to your input CSV file
$outputFolder = "csvfile/output"; // Change this to your desired output folder

// Check if input file exists before attempting to split
if (file_exists($inputFile)) {
    splitCSV($inputFile, $outputFolder);
} else {
    echo "Error: Input file $inputFile not found.";
}

?>
