<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/secondary_collection_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/secondary_collection_report/done/";
$errorFolder = "../../temp_file_csv/censa/secondary_collection_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Prepare the data for insertion
        $unique_id = $line_of_text[0];
        $plant = !empty($line_of_text[1]) ? $line_of_text[1] : '';
        $secondary_plant_id = !empty($line_of_text[2]) ? $line_of_text[2] : '';
        $secondary_plant_name = !empty($line_of_text[3]) ? $line_of_text[3] : '';
        $trip_id = !empty($line_of_text[4]) ? $line_of_text[4] : '';
        $vehicle_number = !empty($line_of_text[5]) ? $line_of_text[5] : '';
        $customer_code = !empty($line_of_text[6]) ? $line_of_text[6] : '';
        $customer_name = mysqli_real_escape_string($conn, $line_of_text[7]);
        $collection_id = !empty($line_of_text[8]) ? $line_of_text[8] : '';
        $collection_date = date('Y-m-d', strtotime($line_of_text[9]));
        $employee_id = !empty($line_of_text[10]) ? $line_of_text[10] : '';
        $employee_name = !empty($line_of_text[11]) ? $line_of_text[11] : '';
        $distributor_name = !empty($line_of_text[12]) ? $line_of_text[12] : '';
        $invoice_id = !empty($line_of_text[13]) ? $line_of_text[13] : '';
        $item_amount = !empty($line_of_text[14]) ? $line_of_text[14] : '';
        $tax_amount = !empty($line_of_text[15]) ? $line_of_text[15] : '';
        $invoice_amount = !empty($line_of_text[16]) ? $line_of_text[16] : '';
        $sales_return_amount = !empty($line_of_text[17]) ? $line_of_text[17] : '';
        $collection_amount = !empty($line_of_text[18]) ? $line_of_text[18] : '';
        $collected_amount = !empty($line_of_text[19]) ? $line_of_text[19] : '';
        $total_kg = !empty($line_of_text[20]) ? $line_of_text[20] : '';
        $sales_return_kg = !empty($line_of_text[21]) ? $line_of_text[21] : '';
        $collection_mode = !empty($line_of_text[22]) ? $line_of_text[22] : '';
        $utr_cheque_dd_number = !empty($line_of_text[23]) ? $line_of_text[23] : '';
        $bank_name = !empty($line_of_text[24]) ? $line_of_text[24] : '';
        $bank_submission_date = date('Y-m-d', strtotime($line_of_text[25]));
        $realization_date = date('Y-m-d', strtotime($line_of_text[26]));
        $collection_source = !empty($line_of_text[25]) ? $line_of_text[27] : '';
        $overall_status = !empty($line_of_text[26]) ? $line_of_text[28] : '';
        $delivery_status = !empty($line_of_text[27]) ? $line_of_text[29] : '';

        if($line_of_text[25] == 0){
            $bank_submission_date = NULL;
        }elseif(!empty($line_of_text[25])) {
            $bank_submission_date = date('Y-m-d', strtotime($line_of_text[25]));
        }else{
            $bank_submission_date = NULL;
        }

        if($line_of_text[26] == 0){
            $realization_date = NULL;
        }elseif(!empty($line_of_text[26])) {
            $realization_date = date('Y-m-d', strtotime($line_of_text[26]));
        }else{
            $realization_date = NULL;
        }

        // Check if the unique_id already exists in the database
        $check_query = "SELECT COUNT(*) AS count FROM censa_secondary_collection_report WHERE unique_id = '$unique_id'";
        $result = $conn->query($check_query);

        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);

            if ($existing_count > 0) {
                // If unique_id already exists, update the existing record
                $update_query = "UPDATE censa_secondary_collection_report SET 
                                    plant = '$plant', 
                                    secondary_plant_id = '$secondary_plant_id', 
                                    secondary_plant_name = '$secondary_plant_name', 
                                    trip_id = '$trip_id', 
                                    vehicle_number = '$vehicle_number', 
                                    customer_code = '$customer_code', 
                                    customer_name = '$customer_name', 
                                    collection_id = '$collection_id', 
                                    collection_date = '$collection_date', 
                                    employee_id = '$employee_id', 
                                    employee_name = '$employee_name', 
                                    distributor_name = '$distributor_name', 
                                    invoice_id = '$invoice_id', 
                                    invoice_amount = '$invoice_amount', 
                                    sales_return_amount = '$sales_return_amount', 
                                    collection_amount = '$collection_amount', 
                                    collected_amount = '$collected_amount', 
                                    total_kg = '$total_kg', 
                                    sales_return_kg = '$sales_return_kg', 
                                    collection_mode = '$collection_mode', 
                                    utr_cheque_dd_number = '$utr_cheque_dd_number', 
                                    bank_name = '$bank_name', 
                                    bank_submission_date = " . ($bank_submission_date ? "'$bank_submission_date'" : "NULL") . ", 
                                    realization_date = " . ($realization_date ? "'$realization_date'" : "NULL") . ", 
                                    collection_source = '$collection_source', 
                                    overall_status = '$overall_status', 
                                    delivery_status = '$delivery_status',
                                    item_amount = '$item_amount',
                                    tax_amount = '$tax_amount'
                                WHERE unique_id = '$unique_id'";

                                // Execute the update query
                                if ($conn->query($update_query) !== TRUE) {
                                    $error_occurred = true;
                                    $error_message = "Error updating record with unique_id '$unique_id': " . $conn->error;
                                    echo $error_message; // Display error message
                
                                    // Send error details via email
                                    sendEmail($error_message);
                
                                    break; // Exit loop if error occurs
                                } else {
                                    echo "Record with unique_id '$unique_id' updated successfully<br>";
                                }
                            } else {
                                // If unique_id does not exist, insert a new record
                                $insert_query = "INSERT INTO censa_secondary_collection_report (unique_id, plant, secondary_plant_id, secondary_plant_name, trip_id, vehicle_number, customer_code, customer_name, collection_id, collection_date, employee_id, employee_name, distributor_name, invoice_id, invoice_amount, sales_return_amount, collection_amount, collected_amount, total_kg, sales_return_kg, collection_mode, utr_cheque_dd_number, bank_name, bank_submission_date, realization_date, collection_source, overall_status, delivery_status,item_amount,tax_amount) 
                                                VALUES ('$unique_id','$plant', '$secondary_plant_id', '$secondary_plant_name', '$trip_id', '$vehicle_number', '$customer_code', '$customer_name', '$collection_id', '$collection_date', '$employee_id', '$employee_name', '$distributor_name', '$invoice_id', '$invoice_amount', '$sales_return_amount', '$collection_amount', '$collected_amount', '$total_kg', '$sales_return_kg', '$collection_mode', '$utr_cheque_dd_number', '$bank_name', " . ($bank_submission_date ? "'$bank_submission_date'" : "NULL") . ", " . ($realization_date ? "'$realization_date'" : "NULL") . ", '$collection_source', '$overall_status', '$delivery_status','$item_amount','$tax_amount')";
                
                                // Execute the insert query
                                if ($conn->query($insert_query) !== TRUE) {
                                    $error_occurred = true;
                                    $error_message = "Error inserting record with unique_id '$unique_id': " . $conn->error;
                                    echo $error_message; // Display error message
                
                                    // Send error details via email
                                    sendEmail($error_message);
                
                                    break; // Exit loop if error occurs
                                } else {
                                    // Store the ID of the successfully inserted row
                                    $inserted_ids[] = $conn->insert_id;
                                    echo "Record with unique_id '$unique_id' inserted successfully<br>";
                                }
                            }
                        } else {
                            $error_occurred = true;
                            $error_message = "Error checking for existing record with unique_id '$unique_id': " . $conn->error;
                            echo $error_message; // Display error message
                
                            // Send error details via email
                            sendEmail($error_message);
                
                            break; // Exit loop if error occurs
                        }
                    }
                
                    // Close the file handle
                    fclose($file_handle);
                
                    // Move the file to the appropriate folder based on success or failure
                    if ($error_occurred) {
                        $destination = $errorFolder . $file;
                        if (!rename($csv_file, $destination)) {
                            echo "Error moving file: $file to $destination";
                        } else {
                            echo "File successfully moved to error folder: $file";
                        }
                    } else {
                        $destination = $doneFolder . $file;
                        if (!rename($csv_file, $destination)) {
                            echo "Error moving file: $file to $destination";
                        } else {
                            echo "File successfully moved to done folder: $file";
                        }
                    }
                
                    // If error occurred, remove all entries inserted from this file
                }
                
                // Close the database connection
                $conn->close();
                
                ?>
                
