<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/schemeid_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/schemeid_report/done/";
$errorFolder = "../../temp_file_csv/censa/schemeid_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Extract data from the CSV line
        $unique_id = $line_of_text[0];
        $company_code = $line_of_text[1];
        $plant = $line_of_text[2];
        $sales_organization = $line_of_text[3];
        $distribution_channel = $line_of_text[4];
        $division = $line_of_text[5];
        $invoiced_date = date('Y-m-d', strtotime($line_of_text[6]));
        $invoice_number = $line_of_text[7];
        $customer_id = $line_of_text[8];
        $customer_name = $conn->real_escape_string($line_of_text[9]);
        $sku = $line_of_text[10];
        $sku_erp_code = $line_of_text[11];
        $scheme_id = $line_of_text[12];
        $scheme_name = $line_of_text[13];

       // Check if unique_id exists
       $check_query = "SELECT COUNT(*) AS count FROM censa_schemeid_report WHERE unique_id = '$unique_id'";
       $result = $conn->query($check_query);
       $row = $result->fetch_assoc();
       $count = $row['count'];
           if ($count > 0) {
               // Run update query
               echo "try to update \n";
               $update_query = "UPDATE censa_schemeid_report 
                         SET company_code = '$company_code', plant = '$plant', sales_organization = '$sales_organization', distribution_channel = '$distribution_channel', division = '$division', invoiced_date = '$invoiced_date', invoice_number = '$invoice_number', customer_id = '$customer_id', customer_name = '$customer_name', sku = '$sku', sku_erp_code = '$sku_erp_code', scheme_id = '$scheme_id', scheme_name = '$scheme_name' 
                         WHERE unique_id = '$unique_id'";
               if ($conn->query($update_query) !== TRUE) {
                   $error_occurred = true;
                   $error_message = "Error updating record: " . $conn->error;
                   echo $error_message; // Display error message

                   // Send error details via email
                   sendEmail($error_message);

                   break; // Exit loop if error occurs
                }
           } else {

               echo "Try to insert";
               // Run insert query
               $insert_query = "INSERT INTO censa_schemeid_report (unique_id,company_code, plant, sales_organization, distribution_channel, division, invoiced_date, invoice_number, customer_id, customer_name, sku, sku_erp_code, scheme_id, scheme_name) 
                         VALUES ('$unique_id','$company_code', '$plant', '$sales_organization', '$distribution_channel', '$division', '$invoiced_date', '$invoice_number', '$customer_id', '$customer_name', '$sku', '$sku_erp_code', '$scheme_id', '$scheme_name')";
               if ($conn->query($insert_query) !== TRUE) {
                   $error_occurred = true;
                   $error_message = "Error inserting record: " . $conn->error;
                   echo $error_message; // Display error message

                   // Send error details via email
                   sendEmail($error_message);

                   break; // Exit loop if error occurs
               }
           }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

    // If error occurred, remove all entries inserted from this file
    if ($error_occurred) {
        // Construct the list of IDs for deletion
        $id_list = implode(",", $inserted_ids);

        // Delete entries from the table
        $delete_sql = "DELETE FROM censa_schemeid_report WHERE id IN ($id_list)";

        if ($conn->query($delete_sql) !== TRUE) {
            echo "Error deleting entries: " . $conn->error;
        }
    }
}

// Close the database connection
$conn->close();

?>