<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/scheme_master/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/scheme_master/done/";
$errorFolder = "../../temp_file_csv/censa/scheme_master/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Prepare data for insertion
        $scheme_id = $line_of_text[0];
        $scheme_name = $line_of_text[1];
        $sku_selection = $line_of_text[2];
        $qualifying_criteria_inclusion = $line_of_text[3];
        $qualifying_criteria_type = $line_of_text[4];
        $qualifying_criteria_value = $line_of_text[5];
        $scheme_type = $line_of_text[6];
        $scheme_value_type = $line_of_text[7];
        $scheme_value = !empty($line_of_text[8]) ? $line_of_text[8] : null;
        $scheme_value = $scheme_value !== '' ? $scheme_value : null;
        $scheme_ceiling_value = $line_of_text[9];
        $validity_starts_on = date('Y-m-d', strtotime($line_of_text[10]));
        $validity_ends_at = date('Y-m-d', strtotime($line_of_text[11]));
        $heading = $line_of_text[12];
        $description = $line_of_text[13];
        $comments = $line_of_text[14];
        $created_by = $line_of_text[15];
        $created_date = date('Y-m-d H:i:s', strtotime($line_of_text[16]));
        
        // Check if scheme_id already exists
        $check_query = "SELECT COUNT(*) AS count FROM censa_scheme_master WHERE scheme_id = '$scheme_id'";
        $result = $conn->query($check_query);

        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);

            if ($existing_count > 0) {
            // Update the existing record
            $update_query = "UPDATE censa_scheme_master SET 
                            scheme_name = '$scheme_name',
                            sku_selection = '$sku_selection',
                            qualifying_criteria_inclusion = '$qualifying_criteria_inclusion',
                            qualifying_criteria_type = '$qualifying_criteria_type',
                            qualifying_criteria_value = '$qualifying_criteria_value',
                            scheme_type = '$scheme_type',
                            scheme_value_type = '$scheme_value_type',
                            scheme_value = '$scheme_value',
                            scheme_ceiling_value = '$scheme_ceiling_value',
                            validity_starts_on = '$validity_starts_on',
                            validity_ends_at = '$validity_ends_at',
                            heading = '$heading',
                            description = '$description',
                            comments = '$comments',
                            created_by = '$created_by',
                            created_date = '$created_date'
                            WHERE scheme_id = '$scheme_id'";

            if ($conn->query($update_query) !== TRUE) {
                $error_occurred = true;
                $error_message = "Error updating record with scheme_id = $scheme_id: " . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                //sendEmail($error_message);
                break; // Exit loop if error occurs
            } else {
                echo "Record with scheme_id = $scheme_id updated successfully.\n";
            }
        } else {
            // Insert a new record
            $insert_query = "INSERT INTO censa_scheme_master (scheme_id, scheme_name, sku_selection, qualifying_criteria_inclusion, qualifying_criteria_type, qualifying_criteria_value, scheme_type, scheme_value_type, scheme_value, scheme_ceiling_value, validity_starts_on, validity_ends_at, heading, description, comments, created_by, created_date) 
                            VALUES ('$scheme_id', '$scheme_name', '$sku_selection', '$qualifying_criteria_inclusion', '$qualifying_criteria_type', '$qualifying_criteria_value', '$scheme_type', '$scheme_value_type', '$scheme_value', '$scheme_ceiling_value', '$validity_starts_on', '$validity_ends_at', '$heading', '$description', '$comments', '$created_by', '$created_date')";
            echo $insert_query;
            if ($conn->query($insert_query) !== TRUE) {
                $error_occurred = true;
                $error_message = "Error inserting record with scheme_id = $scheme_id: " . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                //sendEmail($error_message);
                break; // Exit loop if error occurs
            } else {
                // Get the ID of the inserted record
                $inserted_id = $conn->insert_id;
                // Store the ID for possible rollback
                $inserted_ids[] = $inserted_id;
                echo "Record with scheme_id = $scheme_id inserted successfully.\n";
            }
        }
    } else {
        $error_occurred = true;
        $error_message = "Error checking existing records for unique_id '$scheme_id': " . $conn->error;
        echo $error_message; // Display error message

        // Send error details via email
        sendEmail($error_message);

        break; // Exit loop if error occurs
    }
    }

    // Close the file handle
    fclose($file_handle);
    
    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }
    
    // If error occurred, remove all entries inserted from this file
    
}

// Close the database connection
$conn->close();
?>

