<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/sales_return_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/sales_return_report/done/";
$errorFolder = "../../temp_file_csv/censa/sales_return_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 0, "\t")) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Prepare data for insertion
        $unique_id = $line_of_text[0];
        $zone_id = $line_of_text[1];
        $zone = $line_of_text[2];
        $subzone = $line_of_text[3];
        $subzone_id = $line_of_text[4];
        $dateofbeatplan = date('Y-m-d', strtotime($line_of_text[5]));
        $user_id = $line_of_text[6];
        $user_status = $line_of_text[7];
        $user_name = $line_of_text[8];
        $emp_id = $line_of_text[9];
        $designation = $line_of_text[10];
        $in_date = !empty($line_of_text[11]) ? date('Y-m-d', strtotime($line_of_text[11])) : null;
        $in_time = $line_of_text[12];
        $out_date = !empty($line_of_text[13]) ? date('Y-m-d', strtotime($line_of_text[13])) : null;
        $eod_time = $line_of_text[14];
        $first_call = $line_of_text[15];
        $last_call = $line_of_text[16];
        $time_spent_in_market = $line_of_text[17];
        $beat_id = $line_of_text[18];
        $working_beat = $line_of_text[19];
        $total_outlets = $line_of_text[20];
        $total_calls = $line_of_text[21];
        $new_outlets_created = $line_of_text[22];
        $new_call = $line_of_text[23];
        $order_date = !empty($line_of_text[24]) ? date('Y-m-d', strtotime($line_of_text[24])) : null;
        $salesman_employeeid = $line_of_text[25];
        $pc = $line_of_text[26];
        $order_qty = $line_of_text[27];
        $order_qty_kg = $line_of_text[28];
        $order_amount = $line_of_text[29];
        $maida = $line_of_text[30];
        $sooji = $line_of_text[31];
        $c_atta = $line_of_text[32];
        $p_atta = $line_of_text[33];
        $samba_rava = $line_of_text[34];
        $scvr = $line_of_text[35];
        $lcls = $line_of_text[36];
        $scts = $line_of_text[37];
        $pasta = $line_of_text[38];
        $sca = $line_of_text[39];
        $cottage_semia = $line_of_text[40];
        $hakka_noodles = $line_of_text[41];
        $ragi = $line_of_text[42];
        $rice = $line_of_text[43];
        $gram = $line_of_text[44];
        $idiyappam = $line_of_text[45];
        $mango = $line_of_text[46];
        $mango_tetra = $line_of_text[47];
        $apple = $line_of_text[48];
        $apple_tetra = $line_of_text[49];
        $lemon = $line_of_text[50];
        $cloud_lemon = $line_of_text[51];
        $cola = $line_of_text[52];
        $orange = $line_of_text[53];
        $panner = $line_of_text[54];
        $vanilla = $line_of_text[55];
        $chocolate = $line_of_text[56];
        $badam = $line_of_text[57];
        $gulab_jamun = $line_of_text[58];
        $payasam = $line_of_text[59];
        $lcrv = $line_of_text[60];
        $rava_dosa = $line_of_text[61];
        $rava_upma = $line_of_text[62];
        $rava_idly = $line_of_text[63];
        $naga_combo = $line_of_text[64];
        $choky = $line_of_text[65];
        $choky_fills = $line_of_text[66];
        $kaccha_aam = $line_of_text[67];
        $mango_masti = $line_of_text[68];
        $orange_fun = $line_of_text[69];
        $coffee_time = $line_of_text[70];
        $kozhukattai = $line_of_text[71];
        $cheese_balls = $line_of_text[72];
        $masala_puff = $line_of_text[73];
        $tomato_rings = $line_of_text[74];
        $rusk = $line_of_text[75];
        $hnws = $line_of_text[76];
        $potato_chips = $line_of_text[77];
        $report_updated_at = !empty($line_of_text[78]) ? date('Y-m-d H:i:s', strtotime($line_of_text[78])) : null;

        // Continue with other fields...

        

        // Insert data into the MySQL database
        $sql = "INSERT INTO censa_sales_return_report (unique_id, zone_id, zone, subzone, subzone_id, dateofbeatplan, user_id, user_status, user_name, emp_id, designation, in_date, in_time, out_date, eod_time, first_call, last_call, time_spent_in_market, beat_id, working_beat, total_outlets, total_calls, new_outlets_created, new_call, order_date, salesman_employeeid, pc, order_qty, order_qty_kg, order_amount, maida, sooji, c_atta, p_atta, samba_rava, scvr, lcls, scts, pasta, sca, cottage_semia, hakka_noodles, ragi, rice, gram, idiyappam, mango, mango_tetra, apple, apple_tetra, lemon, cloud_lemon, cola, orange, panner, vanilla, chocolate, badam, report_updated_at) 
        VALUES ('$unique_id', '$zone_id', '$zone', '$subzone', '$subzone_id', '$dateofbeatplan', '$user_id', '$user_status', '$user_name', '$emp_id', '$designation', '$in_date', '$in_time', '$out_date', '$eod_time', '$first_call', '$last_call', '$time_spent_in_market', '$beat_id', '$working_beat', '$total_outlets', '$total_calls', '$new_outlets_created', '$new_call', '$order_date', '$salesman_employeeid', '$pc', '$order_qty', '$order_qty_kg', '$order_amount', '$maida', '$sooji', '$c_atta', '$p_atta', '$samba_rava', '$scvr', '$lcls', '$scts', '$pasta', '$sca', '$cottage_semia', '$hakka_noodles', '$ragi', '$rice', '$gram', '$idiyappam', '$mango', '$mango_tetra', '$apple', '$apple_tetra', '$lemon', '$cloud_lemon', '$cola', '$orange', '$panner', '$vanilla', '$chocolate', '$badam', '$report_updated_at')";

        if ($conn->query($sql) !== TRUE) {
            $error_occurred = true;
            $error_message = "Error: " . $sql . "<br>" . $conn->error;
            echo $error_message; // Display error message

            // Send error details via email
            sendEmail($error_message);

            break; // Exit loop if error occurs
        } else {
            // Store the ID of the successfully inserted row
            $inserted_ids[] = $conn->insert_id;
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

}

// Close the database connection
$conn->close();

?>

