<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/sales_return_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/sales_return_report/done/";
$errorFolder = "../../temp_file_csv/censa/sales_return_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Prepare data for insertion
        $unique_id = $line_of_text[0];
        $trip_id = $line_of_text[1];
        $secondary_plant_id = $line_of_text[2];
        $secondary_plant_name = $line_of_text[3];
        $city = $line_of_text[4];
        $transporter_name = $line_of_text[5];
        $transporter_id = $line_of_text[6];
        $vehicle_no = $line_of_text[7];
        $de_dcd_name = $line_of_text[8];
        $de_dcd_id = $line_of_text[9];
        $customer_id = $line_of_text[10];
        $customer_name = $line_of_text[11];
        $so_no = $line_of_text[12];
        $so_date = !empty($line_of_text[13]) ? date('Y-m-d', strtotime($line_of_text[13])) : null;
        $invoice_no = $line_of_text[14];
        $invoice_date = !empty($line_of_text[15]) ? date('Y-m-d', strtotime($line_of_text[15])) : null;
        $salesreturn_date = !empty($line_of_text[16]) ? date('Y-m-d', strtotime($line_of_text[16])) : null;
        $item_description = $line_of_text[17];
        $item_id = $line_of_text[18];
        $uom = $line_of_text[19];
        $unit_price = !empty($line_of_text[20]) ? $line_of_text[20] : '';
        $invoice_qty = $line_of_text[21];
        $return_qty = $line_of_text[22];
        // New fields
        $sec_sr_qty = !empty($line_of_text[23]) ? $line_of_text[23] : '';
        $checked_sec_sr_qty = !empty($line_of_text[24]) ? $line_of_text[24] : '';
        $prim_sr_qty_picked = !empty($line_of_text[25]) ? $line_of_text[25] : '';
        $checked_prim_sr_qty = !empty($line_of_text[26]) ? $line_of_text[26] : '';
        $return_so_no = !empty($line_of_text[27]) ? $line_of_text[27] : '';
        $invoice_item_value = !empty($line_of_text[28]) ? $line_of_text[28] : '';
        $return_item_value = !empty($line_of_text[29]) ? $line_of_text[29] : '';
        $collection_value = !empty($line_of_text[30]) ? $line_of_text[30] : '';
        $collected_value = !empty($line_of_text[31]) ? $line_of_text[31] : '';
        $collection_mode = !empty($line_of_text[32]) ? $line_of_text[32] : '';
        $itemsupplied_item_net_weight = intval(!empty($line_of_text[33]) ? $line_of_text[33] : '');
        $delivery_status = $line_of_text[34];
        $pod = $line_of_text[35];
        $return_pct = intval($line_of_text[36]); 
        $return_remarks = $line_of_text[37];
                // Check if the unique_id already exists in the database
                $check_query = "SELECT COUNT(*) AS count FROM censa_sales_return_report WHERE unique_id = '$unique_id'";
                $result = $conn->query($check_query);
        
                if ($result) {
                    $row = $result->fetch_assoc();
                    $existing_count = intval($row['count']);
        
                    if ($existing_count > 0) {
                        // If unique_id already exists, update the existing record
                        $update_query = "UPDATE censa_sales_return_report SET 
                                            trip_id = '$trip_id', 
                                            secondary_plant_id = '$secondary_plant_id', 
                                            secondary_plant_name = '$secondary_plant_name', 
                                            city = '$city', 
                                            transporter_name = '$transporter_name', 
                                            transporter_id = '$transporter_id', 
                                            vehicle_no = '$vehicle_no', 
                                            de_dcd_name = '$de_dcd_name', 
                                            de_dcd_id = '$de_dcd_id', 
                                            customer_id = '$customer_id', 
                                            customer_name = '$customer_name', 
                                            so_no = '$so_no', 
                                            so_date = '$so_date', 
                                            invoice_no = '$invoice_no', 
                                            invoice_date = '$invoice_date', 
                                            salesreturn_date = '$salesreturn_date', 
                                            item_description = '$item_description', 
                                            uom = '$uom', 
                                            unit_price = '$unit_price', 
                                            invoice_qty = '$invoice_qty', 
                                            return_qty = '$return_qty',
                                            sec_sr_qty = '$sec_sr_qty',
                                            checked_sec_sr_qty = '$checked_sec_sr_qty',
                                            prim_sr_qty_picked = '$prim_sr_qty_picked',
                                            checked_prim_sr_qty = '$checked_prim_sr_qty',
                                            return_so_no = '$return_so_no',
                                            invoice_item_value = '$invoice_item_value',
                                            return_item_value = '$return_item_value',
                                            collection_value = '$collection_value',
                                            collected_value = '$collected_value',
                                            collection_mode = '$collection_mode',
                                            itemsupplied_item_net_weight = '$itemsupplied_item_net_weight',
                                            delivery_status = '$delivery_status',
                                            pod = '$pod',
                                            return_pct = '$return_pct',
                                            return_remarks = '$return_remarks'
                                        WHERE unique_id = '$unique_id'";
        
                        // Execute the update query
                        if ($conn->query($update_query) !== TRUE) {
                            $error_occurred = true;
                            $error_message = "Error updating record with unique_id = $unique_id: " . $conn->error;
                            echo $error_message; // Display error message
        
                            // Send error details via email
                            //sendEmail($error_message);
        
                            break; // Exit loop if error occurs
                        } else {
                            echo "Record with unique_id = $unique_id updated successfully.\n";
                        }
                    } else {
                        // If unique_id does not exist, insert a new record
                        $insert_query = "INSERT INTO censa_sales_return_report (unique_id, trip_id, secondary_plant_id, secondary_plant_name, city, transporter_name, transporter_id, vehicle_no, de_dcd_name, de_dcd_id, customer_id, customer_name, so_no, so_date, invoice_no, invoice_date, salesreturn_date, item_description, item_id, uom, unit_price, invoice_qty, return_qty, sec_sr_qty, checked_sec_sr_qty, prim_sr_qty_picked, checked_prim_sr_qty, return_so_no, invoice_item_value, return_item_value, collection_value, collected_value, collection_mode, itemsupplied_item_net_weight, delivery_status, pod, return_pct, return_remarks) 
                                            VALUES ('$unique_id','$trip_id', '$secondary_plant_id', '$secondary_plant_name', '$city', '$transporter_name', '$transporter_id', '$vehicle_no', '$de_dcd_name', '$de_dcd_id', '$customer_id', '$customer_name', '$so_no', '$so_date', '$invoice_no', '$invoice_date', '$salesreturn_date', '$item_description', '$item_id', '$uom', '$unit_price', '$invoice_qty', '$return_qty', '$sec_sr_qty', '$checked_sec_sr_qty', '$prim_sr_qty_picked', '$checked_prim_sr_qty', '$return_so_no', '$invoice_item_value', '$return_item_value', '$collection_value', '$collected_value', '$collection_mode', '$itemsupplied_item_net_weight', '$delivery_status', '$pod', '$return_pct', '$return_remarks')";
        
                        // Execute the insert query
                        if ($conn->query($insert_query) !== TRUE) {
                            $error_occurred = true;
                            $error_message = "Error inserting record with unique_id = $unique_id: " . $conn->error;
                            echo $error_message; // Display error message
        
                            // Send error details via email
                            //sendEmail($error_message);
                            break; // Exit loop if error occurs
                        }else{
                            echo "Insert Done";
                        }
                    }
                } else {
                    $error_occurred = true;
                    $error_message = "Error in query: " . $conn->error;
                    echo $error_message; // Display error message
        
                    // Send error details via email
                    //sendEmail($error_message);
                    break; // Exit loop if error occurs
                }
            }
        
        
        // Close the file handle
        fclose($file_handle);
        
        // Move the file to the appropriate folder based on success or failure
        if ($error_occurred) {
            $destination = $errorFolder . $file;
            if (!rename($csv_file, $destination)) {
                echo "Error moving file: $file to $destination";
            } else {
                echo "File successfully moved to error folder: $file";
            }
        } else {
            $destination = $doneFolder . $file;
            if (!rename($csv_file, $destination)) {
                echo "Error moving file: $file to $destination";
            } else {
                echo "File successfully moved to done folder: $file";
            }
        }
        
        // If error occurred, remove all entries inserted from this file
        if ($error_occurred) {
            // Construct the list of IDs for deletion
            $id_list = implode(",", $inserted_ids);
        
            // Delete entries from the table
            $delete_sql = "DELETE FROM censa_sales_return_report WHERE id IN ($id_list)";
        
            if ($conn->query($delete_sql) !== TRUE) {
                echo "Error deleting entries: " . $conn->error;
            }
        }
        
        // Close the database connection
        $conn->close();
}
        ?>
        