<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/mjp_schedule_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/mjp_schedule_report/done/";
$errorFolder = "../../temp_file_csv/censa/mjp_schedule_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Extract data from the CSV line
        $unique_id = $line_of_text[0];
        $sales_office_id = !empty($line_of_text[1]) ? $line_of_text[1] : '';
        $sales_office = !empty($line_of_text[2]) ? $line_of_text[2] : '';
        $sales_group_id = !empty($line_of_text[3]) ? $line_of_text[3] : '';
        $sales_group = !empty($line_of_text[4]) ? $line_of_text[4] : '';
        $employee_id = !empty($line_of_text[5]) ? $line_of_text[5] : '';
        $user_name = !empty($line_of_text[6]) ? $line_of_text[6] : '';
        $login_username = !empty($line_of_text[7]) ? $line_of_text[7] : '';
        $distributor_name = !empty($line_of_text[8]) ? $line_of_text[8] : '';
        $beat_id = !empty($line_of_text[9]) ? $line_of_text[9] : '';
        $days = !empty($line_of_text[10]) ? $line_of_text[10] : '';
        $beat_date = date('Y-m-d', strtotime($line_of_text[11]));
        $total_no_of_outlets = intval($line_of_text[12]);
        $frequency = intval($line_of_text[13]);

        // Check if the unique_id already exists in the database
        $check_query = "SELECT COUNT(*) AS count FROM censa_mjp_schedule_report WHERE unique_id = '$unique_id'";
        $result = $conn->query($check_query);

        if ($result) {
            $row = $result->fetch_assoc();
            $existing_count = intval($row['count']);

            if ($existing_count > 0) {
                // If unique_id already exists, update the existing record
                $update_query = "UPDATE censa_mjp_schedule_report SET 
                                    sales_office_id = '$sales_office_id', 
                                    sales_office = '$sales_office', 
                                    sales_group_id = '$sales_group_id', 
                                    sales_group = '$sales_group', 
                                    employee_id = '$employee_id', 
                                    user_name = '$user_name', 
                                    distributor_name = '$distributor_name', 
                                    beat_id = '$beat_id', 
                                    days = '$days', 
                                    beat_date = '$beat_date', 
                                    total_no_of_outlets = '$total_no_of_outlets',
                                    login_username = '$login_username',
                                    frequency = '$frequency'
                                WHERE unique_id = '$unique_id'";

                // Execute the update query
                if ($conn->query($update_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error updating record with unique_id = $unique_id: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);

                    break; // Exit loop if error occurs
                } else {
                    echo "Record with unique_id = $unique_id updated successfully.\n";
                }
            } else {
                // If unique_id does not exist, insert a new record
                $insert_query = "INSERT INTO censa_mjp_schedule_report (unique_id, sales_office_id, sales_office, sales_group_id, sales_group, employee_id, user_name, distributor_name, beat_id, days, beat_date, total_no_of_outlets,frequency,login_username) 
                                    VALUES ('$unique_id','$sales_office_id', '$sales_office', '$sales_group_id', '$sales_group', '$employee_id', '$user_name', '$distributor_name', '$beat_id', '$days', '$beat_date', '$total_no_of_outlets','$frequency','$login_username')";
                // Execute the insert query
                if ($conn->query($insert_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error inserting record with unique_id = $unique_id: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);
                    break; // Exit loop if error occurs
                } else {
                    echo "Record with unique_id = $unique_id inserted successfully.\n";
                }
            }
        } else {
            $error_occurred = true;
            $error_message = "Error in query: " . $conn->error;
            echo $error_message; // Display error message

            // Send error details via email
            sendEmail($error_message);
            break; // Exit loop if error occurs
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

    // If error occurred, remove all entries inserted from this file
    if ($error_occurred) {
        // Construct the list of IDs for deletion
        $id_list = implode(",", $inserted_ids);

        // Delete entries from the table
        $delete_sql = "DELETE FROM censa_mjp_schedule_report WHERE id IN ($id_list)";

        if ($conn->query($delete_sql) !== TRUE) {
            echo "Error deleting entries: " . $conn->error;
        }
    }
}

// Close the database connection
$conn->close();

?>
