<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/employee_master/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/employee_master/done/";
$errorFolder = "../../temp_file_csv/censa/employee_master/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 0, ",")) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }
        // Extracting data from CSV line
        $employee_id = $line_of_text[0];
        $alternate_employee_code = !empty($line_of_text[1]) ? $line_of_text[1] : '';
        $employee_first_name = !empty($line_of_text[2]) ? $line_of_text[2] : '';
        $employee_last_name = !empty($line_of_text[3]) ? $line_of_text[3] : '';
        $employee_email = !empty($line_of_text[4]) ? $line_of_text[4] : '';
        $phone_number = !empty($line_of_text[5]) ? $line_of_text[5] : '';
        $created_on = !empty($line_of_text[6]) ? date('Y-m-d', strtotime($line_of_text[6])) : '';
        $created_by = !empty($line_of_text[7]) ? $line_of_text[7] : '';
        $employee_status = !empty($line_of_text[8]) ? $line_of_text[8] : '';
        $user_role = !empty($line_of_text[9]) ? $line_of_text[9] : '';
        $employee_reporting_manager = !empty($line_of_text[10]) ? $line_of_text[10] : '';
        $department = !empty($line_of_text[11]) ? $line_of_text[11] : '';
        $employee_designation = !empty($line_of_text[12]) ? $line_of_text[12] : '';
        $hq = !empty($line_of_text[13]) ? $line_of_text[13] : '';
        $employment_type = !empty($line_of_text[14]) ? $line_of_text[14] : '';

        // Check if employee_id already exists
        $check_sql = "SELECT COUNT(*) AS count FROM censa_employee_table WHERE employee_id = '$employee_id'";
        $result = $conn->query($check_sql);
        $row = $result->fetch_assoc();
        $existing_count = intval($row['count']);

        if ($existing_count > 0) {
            // Employee already exists, update the record
            $update_sql = "UPDATE censa_employee_table 
                           SET alternate_employee_code = '$alternate_employee_code', 
                               employee_first_name = '$employee_first_name', 
                               employee_last_name = '$employee_last_name', 
                               employee_email = '$employee_email', 
                               phone_number = '$phone_number', 
                               created_on = '$created_on', 
                               created_by = '$created_by', 
                               employee_status = '$employee_status', 
                               user_role = '$user_role', 
                               employee_reporting_manager = '$employee_reporting_manager', 
                               department = '$department', 
                               employee_designation = '$employee_designation', 
                               hq = '$hq', 
                               employment_type = '$employment_type' 
                           WHERE employee_id = '$employee_id'";

            if ($conn->query($update_sql) !== TRUE) {
                $error_occurred = true;
                $error_message = "Error updating record: " . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                sendEmail($error_message);

                break; // Exit loop if error occurs
            }
        } else {
            // Employee does not exist, insert a new record
            $insert_sql = "INSERT INTO censa_employee_table 
                           (employee_id, alternate_employee_code, employee_first_name, employee_last_name, employee_email, phone_number, created_on, created_by, employee_status, user_role, employee_reporting_manager, department, employee_designation, hq, employment_type) 
                           VALUES 
                           ('$employee_id', '$alternate_employee_code', '$employee_first_name', '$employee_last_name', '$employee_email', '$phone_number', '$created_on', '$created_by', '$employee_status', '$user_role', '$employee_reporting_manager', '$department', '$employee_designation', '$hq', '$employment_type')";

            if ($conn->query($insert_sql) !== TRUE) {
                $error_occurred = true;
                $error_message = "Error inserting record: " . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                sendEmail($error_message);

                break; // Exit loop if error occurs
            }
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }

}

// Close the database connection
$conn->close();

?>
