<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/customer_cd_mapping_master/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/customer_cd_mapping_master/done/";
$errorFolder = "../../temp_file_csv/censa/customer_cd_mapping_master/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 0, ",")) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }
        $unique_id = $line_of_text[0];
        $company_code = !empty($line_of_text[1]) ? $line_of_text[1] : '';
        $sales_organization = !empty($line_of_text[2]) ? $line_of_text[2] : '';
        $distribution_channel = !empty($line_of_text[3]) ? $line_of_text[3] : '';
        $division = !empty($line_of_text[4]) ? $line_of_text[4] : '';
        $primary_plant_id = !empty($line_of_text[5]) ? $line_of_text[5] : '';
        $primary_plant_name = !empty($line_of_text[6]) ? $line_of_text[6] : '';
        $secondary_plant_id = !empty($line_of_text[7]) ? $line_of_text[7] : '';
        $secondary_plant_name = !empty($line_of_text[8]) ? $line_of_text[8] : '';
        $customer_id = !empty($line_of_text[9]) ? $line_of_text[9] : '';
        $customer_name = !empty($line_of_text[10]) ? $line_of_text[10] : '';
        $latitude = !empty($line_of_text[11]) ? $line_of_text[11] : '';
        $longitude = !empty($line_of_text[12]) ? $line_of_text[12] : '';

        // Check if customer_id already exists
        $check_sql = "SELECT COUNT(*) AS count FROM censa_customer_cd_mapping_master WHERE customer_id = ?";
        $stmt = $conn->prepare($check_sql);
        $stmt->bind_param("s", $customer_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        $existing_count = intval($row['count']);
        $stmt->close();

        if ($existing_count > 0) {
            // Customer already exists, update the record
            $update_sql = "UPDATE censa_customer_cd_mapping_master 
                           SET company_code = ?, 
                               sales_organization = ?, 
                               distribution_channel = ?, 
                               division = ?, 
                               primary_plant_id = ?, 
                               primary_plant_name = ?, 
                               secondary_plant_id = ?, 
                               secondary_plant_name = ?, 
                               customer_name = ?,
                               latitude = ?,
                               longitude = ?
                           WHERE customer_id = ?";
            $stmt = $conn->prepare($update_sql);
            $stmt->bind_param("ssssssssssds", $company_code, $sales_organization, $distribution_channel, $division, $primary_plant_id, $primary_plant_name, $secondary_plant_id, $secondary_plant_name, $customer_name, $latitude, $longitude, $customer_id);
            if (!$stmt->execute()) {
                $error_occurred = true;
                $error_message = "Error updating record: " . $stmt->error;
                echo $error_message; // Display error message

                // Send error details via email
                sendEmail($error_message);
                break; // Exit loop if error occurs
            }
            $stmt->close();
        } else {
            // Customer does not exist, insert a new record
            $insert_sql = "INSERT INTO censa_customer_cd_mapping_master 
                           (company_code, sales_organization, distribution_channel, division, primary_plant_id, primary_plant_name, secondary_plant_id, secondary_plant_name, customer_id, customer_name, latitude, longitude) 
                           VALUES 
                           (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($insert_sql);
            $stmt->bind_param("ssssssssssds", $company_code, $sales_organization, $distribution_channel, $division, $primary_plant_id, $primary_plant_name, $secondary_plant_id, $secondary_plant_name, $customer_id, $customer_name, $latitude, $longitude);
            if (!$stmt->execute()) {
                $error_occurred = true;
                $error_message = "Error inserting record: " . $stmt->error;
                echo $error_message; // Display error message

                // Send error details via email
                sendEmail($error_message);
                break; // Exit loop if error occurs
            }
            $stmt->close();
        }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }
}

// Close the database connection
$conn->close();

?>
