<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include MySQL connection file
require_once "mysql_connection.php";

// Include email functionality file
require_once "send_email.php";

// Directory containing CSV files
$csv_directory = "../../censa/censa_reports/attendance_report/";

// Destination folders
$doneFolder = "../../temp_file_csv/censa/attendance_report/done/";
$errorFolder = "../../temp_file_csv/censa/attendance_report/error/";

// Get the list of files in the directory 
$files = scandir($csv_directory);

// Iterate through each file in the directory
foreach ($files as $file) {
    // Skip special directory entries
    if ($file == "." || $file == "..") {
        continue;
    }

    // Path to the current CSV file
    $csv_file = $csv_directory . $file;

    // Read the CSV file
    $file_handle = fopen($csv_file, 'r');

    if (!$file_handle) {
        die("Error opening file: $csv_file");
    }

    // Variable to track if it's the first row
    $is_first_row = true;

    // Flag to determine if there was an error during processing
    $error_occurred = false;

    // Store the IDs of successfully inserted rows
    $inserted_ids = [];

    // Iterate through each line of the CSV file
    while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
        // Skip the first row (header row)
        if ($is_first_row) {
            $is_first_row = false;
            continue;
        }

        // Convert date format from MM/DD/YYYY to YYYY-MM-DD
        $unique_id = $line_of_text[0];
        $date = date('Y-m-d', strtotime($line_of_text[1]));
        $plant = intval($line_of_text[2]);
        $employee_id = $line_of_text[3];
        $alternative_employee_id = $line_of_text[4];
        $user_type = $line_of_text[5];
        $user_status = $line_of_text[6];
        $user_name = $line_of_text[7];
        $login_user_name = $line_of_text[8];
        $checkin_date = date('Y-m-d', strtotime($line_of_text[10]));
        $checkin_time = date("H:i:s", strtotime($line_of_text[9]));
        $checkout_date = date('Y-m-d', strtotime($line_of_text[11]));
        $checkout_time = date("H:i:s", strtotime($line_of_text[12]));
        $tat_in_hours = $line_of_text[13];
        $checkin_latitude = !empty($line_of_text[14]) ? $line_of_text[14] : '0.0000'; // Check if checkout_latitude is empty 
        $checkin_longitude = !empty($line_of_text[15]) ? $line_of_text[15] : '0.0000'; // Check if checkout_latitude is empty
        $checkout_latitude = !empty($line_of_text[16]) ? $line_of_text[16] : '0.0000'; // Check if checkout_latitude is empty
        $checkout_longitude = !empty($line_of_text[17]) ? $line_of_text[17] : '0.0000'; // Check if checkout_latitude is empty

        // Check if unique_id exists
        $check_query = "SELECT COUNT(*) AS count FROM censa_attendance_report WHERE id = '$unique_id'";
        $result = $conn->query($check_query);
        $row = $result->fetch_assoc();
        $count = $row['count'];
            if ($count > 0) {
                // Run update query
                echo "try to update \n";
                $update_query = "UPDATE censa_attendance_report 
                                SET date = '$date', plant = '$plant', employee_id = '$employee_id', alternative_employee_id = '$alternative_employee_id', user_type = '$user_type', user_status = '$user_status', user_name = '$user_name', login_user_name = '$login_user_name', checkin_date = '$checkin_date', checkin_time = '$checkin_time', checkout_date = '$checkout_date', checkout_time = '$checkout_time', tat_in_hours = '$tat_in_hours', checkin_latitude = '$checkin_latitude', checkin_longitude = '$checkin_longitude', checkout_latitude = '$checkout_latitude', checkout_longitude = '$checkout_longitude' 
                                WHERE id = '$unique_id'";
                if ($conn->query($update_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error updating record: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);

                    break; // Exit loop if error occurs
                 }
            } else {

                echo "Try to insert";
                // Run insert query
                $insert_query = "INSERT INTO censa_attendance_report (id, date, plant, employee_id, alternative_employee_id, user_type, user_status, user_name, login_user_name, checkin_date, checkin_time, checkout_date, checkout_time, tat_in_hours, checkin_latitude, checkin_longitude, checkout_latitude, checkout_longitude) 
                                VALUES ('$unique_id', '$date', '$plant', '$employee_id', '$alternative_employee_id', '$user_type', '$user_status', '$user_name', '$login_user_name', '$checkin_date', '$checkin_time', '$checkout_date', '$checkout_time', '$tat_in_hours', '$checkin_latitude', '$checkin_longitude', '$checkout_latitude', '$checkout_longitude')";
                if ($conn->query($insert_query) !== TRUE) {
                    $error_occurred = true;
                    $error_message = "Error inserting record: " . $conn->error;
                    echo $error_message; // Display error message

                    // Send error details via email
                    sendEmail($error_message);

                    break; // Exit loop if error occurs
                }
            }
    }

    // Close the file handle
    fclose($file_handle);

    // Move the file to the appropriate folder based on success or failure
    if ($error_occurred) {
        $destination = $errorFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to error folder: $file";
        }
    } else {
        $destination = $doneFolder . $file;
        if (!rename($csv_file, $destination)) {
            echo "Error moving file: $file to $destination";
        } else {
            echo "File successfully moved to done folder: $file";
        }
    }
}

// Close the database connection
$conn->close();

?>
