    <?php

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    // Include MySQL connection file
    require_once "mysql_connection.php";

    // Include email functionality file
    require_once "send_email.php";

    // Directory containing CSV files
    $csv_directory = "../../censa/censa_reports/activity_report/";

    // Destination folders
    $doneFolder = "../../temp_file_csv/censa/activity_report/done/";
    $errorFolder = "../../temp_file_csv/censa/activity_report/error/";

    // Get the list of files in the directory 
    $files = scandir($csv_directory);

    // Iterate through each file in the directory
    foreach ($files as $file) {
        // Skip special directory entries
        if ($file == "." || $file == "..") {
            continue;
        }

        // Path to the current CSV file
        $csv_file = $csv_directory . $file;

        // Read the CSV file
        $file_handle = fopen($csv_file, 'r');

        if (!$file_handle) {
            die("Error opening file: $csv_file");
        }

        // Variable to track if it's the first row
        $is_first_row = true;

        // Flag to determine if there was an error during processing
        $error_occurred = false;

        // Store the IDs of successfully inserted rows
        $inserted_ids = [];

        // Iterate through each line of the CSV file
        while (($line_of_text = fgetcsv($file_handle, 1024)) !== false) {
            // Skip the first row (header row)
            if ($is_first_row) {
                $is_first_row = false;
                continue;
            }

            // Convert date format from MM/DD/YYYY to YYYY-MM-DD
            $unique_id = $line_of_text[0];
            $date = date('Y-m-d', strtotime($line_of_text[1]));
            $total_number_of_outlets = intval($line_of_text[21]);
            $plant = intval($line_of_text[2]);
            $customer_id = intval($line_of_text[9]);
            $visited = intval($line_of_text[17] == 'FLASH') ? 0 : (($line_of_text[16] == 'TRUE') ? 1 : 0);
            $orderplaced = ($line_of_text[18] == 'FLASH') ? 0 : (($line_of_text[17] == 'TRUE') ? 1 : 0);
            $ordervisited = ($line_of_text[19] == 'FLASH') ? 0 : (($line_of_text[18] == 'TRUE') ? 1 : 0);
            $activity = $line_of_text[16];

            // Convert latitude value only if it is not empty
            if (!empty($line_of_text[12])) {
            $master_latitude = floatval($line_of_text[12]);
            } else {
            // Handle the case where latitude is empty (you might want to set a default value or handle it differently based on your requirements)
            $master_latitude = 0.0; // Set a default value of 0.0 for latitude
            }
            // Convert latitude value only if it is not empty
            if (!empty($line_of_text[13])) {
                $master_longitude = floatval($line_of_text[13]);
                } else {
                // Handle the case where latitude is empty (you might want to set a default value or handle it differently based on your requirements)
                $master_longitude = 0.0; // Set a default value of 0.0 for latitude
                }
                if (!empty($line_of_text[14])) {
                    $customer_longitude = floatval($line_of_text[14]);
                    } else {
                    // Handle the case where latitude is empty (you might want to set a default value or handle it differently based on your requirements)
                    $customer_longitude = 0.0; // Set a default value of 0.0 for latitude
                    }
                    if (!empty($line_of_text[15])) {
                        $customer_latitude = floatval($line_of_text[15]);
                        } else {
                        // Handle the case where latitude is empty (you might want to set a default value or handle it differently based on your requirements)
                        $customer_latitude = 0.0; // Set a default value of 0.0 for latitude
                        }
                // Convert deviation_km value only if it is not empty
            if (!empty($line_of_text[23])) {
            $deviation_km = floatval($line_of_text[23]);
            } else {
            // Handle the case where deviation_km is empty (you might want to set a default value or handle it differently based on your requirements)
            $deviation_km = 0.0; // Set a default value of 0.0 for deviation_km
            }
            $checkin_date_time = substr($line_of_text[4], 0, 19); // Assuming the datetime format is 'YYYY-MM-DD HH:MM:SS'
            $checkout_date_time = substr($line_of_text[5], 0, 19); // Assuming the datetime format is 'YYYY-MM-DD HH:MM:SS'

            $select_sql = "SELECT * FROM censa_activity_report WHERE checkin_date_time = '$checkin_date_time' AND customer_id = '$customer_id'";
            $result = $conn->query($select_sql);

            if ($result->num_rows > 0) {
            echo "Record with checkin_date_time: $checkin_date_time and customer_id: $customer_id already exists. Skipping insertion.";
            continue; // Skip insertion and move to the next record
            }
            // Escape single quotes in the string values to avoid SQL syntax errors
            $plant_name = $conn->real_escape_string($line_of_text[3]);
            $employee = $conn->real_escape_string($line_of_text[8]);
            $customer_name = $conn->real_escape_string($line_of_text[10]);
            $call_type = $conn->real_escape_string($line_of_text[11]);
            $reason_for_forcecheckin = $conn->real_escape_string($line_of_text[24]);

            $sql = "INSERT INTO censa_activity_report (unique_id, date, plant, plant_name, checkin_date_time, checkout_date_time, app_portal, employee_id, employee, customer_id, customer_name, call_type, master_latitude, master_longitude, customer_longitude, customer_latitude, activity, visited, orderplaced, ordervisited, beat_id, working_beat, total_number_of_outlets, deviation_km, reason_for_forcecheckin) 
                    VALUES ('$unique_id', '$date', '$plant', '$plant_name', '$checkin_date_time', '$checkout_date_time', '$line_of_text[6]', '$line_of_text[7]', '$employee', '$customer_id', '$customer_name', '$call_type', '$master_latitude', '$master_longitude', '$customer_longitude', '$customer_latitude', '$activity', '$visited', '$orderplaced', '$ordervisited', '$line_of_text[20]', '$line_of_text[21]', '$total_number_of_outlets', $deviation_km, '$reason_for_forcecheckin')";
            if ($conn->query($sql) !== TRUE) {
                $error_occurred = true;
                $error_message = "Error: " . $sql . "<br>" . $conn->error;
                echo $error_message; // Display error message

                // Send error details via email
                sendEmail($error_message);

                break; // Exit loop if error occurs
            } else {
                // Store the ID of the successfully inserted row
                $inserted_ids[] = $conn->insert_id;
            }
        }

        // Close the file handle
        fclose($file_handle);

        // Move the file to the appropriate folder based on success or failure
        if ($error_occurred) {
            $destination = $errorFolder . $file;
            if (!rename($csv_file, $destination)) {
                echo "Error moving file: $file to $destination";
            } else {
                echo "File successfully moved to error folder: $file";
            }
        } else {
            $destination = $doneFolder . $file;
            if (!rename($csv_file, $destination)) {
                echo "Error moving file: $file to $destination";
            } else {
                echo "File successfully moved to done folder: $file";
            }
        }

        // If error occurred, remove all entries inserted from this file
        if ($error_occurred) {
            // Construct the list of IDs for deletion
            $id_list = implode(",", $inserted_ids);

            // Delete entries from the table
            $delete_sql = "DELETE FROM censa_activity_report WHERE id IN ($id_list)";

            if ($conn->query($delete_sql) !== TRUE) {
                echo "Error deleting entries: " . $conn->error;
            }
        }
    }

    // Close the database connection
    $conn->close();

    ?>
